#if BURST_INTERNAL || UNITY_BURST_EXPERIMENTAL_NEON_INTRINSICS
using System;
using System.Diagnostics;

namespace Unity.Burst.Intrinsics
{
    public unsafe static partial class Arm
    {
        /// <summary>
        /// Neon intrinsics
        /// </summary>
        public unsafe partial class Neon
        {
            /// <summary>Floating-point Add (vector). This instruction adds corresponding vector elements in the two source SIMD&amp;FP registers, writes the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FADD Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vadd_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Add (vector). This instruction adds corresponding vector elements in the two source SIMD&amp;FP registers, writes the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FADD Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vaddq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add (vector). This instruction adds corresponding elements in the two source SIMD&amp;FP registers, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADD Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static Int64 vaddd_s64(Int64 a0, Int64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add (vector). This instruction adds corresponding elements in the two source SIMD&amp;FP registers, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADD Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vaddd_u64(UInt64 a0, UInt64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Add Long (vector). This instruction adds each vector element in the lower or upper half of the first source SIMD&amp;FP register to the corresponding vector element of the second source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.  The destination vector elements are twice as long as the source vector elements. All the values in this instruction are signed integer values.The SADDL instruction extracts each source vector from the lower half of each source register, while the SADDL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SADDL2 Vd.8H,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vaddl_high_s8(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Add Long (vector). This instruction adds each vector element in the lower or upper half of the first source SIMD&amp;FP register to the corresponding vector element of the second source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.  The destination vector elements are twice as long as the source vector elements. All the values in this instruction are signed integer values.The SADDL instruction extracts each source vector from the lower half of each source register, while the SADDL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SADDL2 Vd.4S,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vaddl_high_s16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Add Long (vector). This instruction adds each vector element in the lower or upper half of the first source SIMD&amp;FP register to the corresponding vector element of the second source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.  The destination vector elements are twice as long as the source vector elements. All the values in this instruction are signed integer values.The SADDL instruction extracts each source vector from the lower half of each source register, while the SADDL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SADDL2 Vd.2D,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vaddl_high_s32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Add Long (vector). This instruction adds each vector element in the lower or upper half of the first source SIMD&amp;FP register to the corresponding vector element of the second source SIMD&amp;FP register, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements. All the values in this instruction are unsigned integer values.The UADDL instruction extracts each source vector from the lower half of each source register, while the UADDL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UADDL2 Vd.8H,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vaddl_high_u8(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Add Long (vector). This instruction adds each vector element in the lower or upper half of the first source SIMD&amp;FP register to the corresponding vector element of the second source SIMD&amp;FP register, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements. All the values in this instruction are unsigned integer values.The UADDL instruction extracts each source vector from the lower half of each source register, while the UADDL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UADDL2 Vd.4S,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vaddl_high_u16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Add Long (vector). This instruction adds each vector element in the lower or upper half of the first source SIMD&amp;FP register to the corresponding vector element of the second source SIMD&amp;FP register, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements. All the values in this instruction are unsigned integer values.The UADDL instruction extracts each source vector from the lower half of each source register, while the UADDL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UADDL2 Vd.2D,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vaddl_high_u32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Add Wide. This instruction adds vector elements of the first source SIMD&amp;FP register to the corresponding vector elements in the lower or upper half of the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the SIMD&amp;FP destination register.The SADDW instruction extracts the second source vector from the lower half of the second source register, while the SADDW2 instruction extracts the second source vector from the upper half of the second source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SADDW2 Vd.8H,Vn.8H,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vaddw_high_s8(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Add Wide. This instruction adds vector elements of the first source SIMD&amp;FP register to the corresponding vector elements in the lower or upper half of the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the SIMD&amp;FP destination register.The SADDW instruction extracts the second source vector from the lower half of the second source register, while the SADDW2 instruction extracts the second source vector from the upper half of the second source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SADDW2 Vd.4S,Vn.4S,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vaddw_high_s16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Add Wide. This instruction adds vector elements of the first source SIMD&amp;FP register to the corresponding vector elements in the lower or upper half of the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the SIMD&amp;FP destination register.The SADDW instruction extracts the second source vector from the lower half of the second source register, while the SADDW2 instruction extracts the second source vector from the upper half of the second source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SADDW2 Vd.2D,Vn.2D,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vaddw_high_s32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Add Wide. This instruction adds the vector elements of the first source SIMD&amp;FP register to the corresponding vector elements in the lower or upper half of the second source SIMD&amp;FP register, places the result in a vector, and writes the vector to the SIMD&amp;FP destination register. The vector elements of the destination register and the first source register are twice as long as the vector elements of the second source register. All the values in this instruction are unsigned integer values.The UADDW instruction extracts vector elements from the lower half of the second source register, while the UADDW2 instruction extracts vector elements from the upper half of the second source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UADDW2 Vd.8H,Vn.8H,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vaddw_high_u8(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Add Wide. This instruction adds the vector elements of the first source SIMD&amp;FP register to the corresponding vector elements in the lower or upper half of the second source SIMD&amp;FP register, places the result in a vector, and writes the vector to the SIMD&amp;FP destination register. The vector elements of the destination register and the first source register are twice as long as the vector elements of the second source register. All the values in this instruction are unsigned integer values.The UADDW instruction extracts vector elements from the lower half of the second source register, while the UADDW2 instruction extracts vector elements from the upper half of the second source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UADDW2 Vd.4S,Vn.4S,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vaddw_high_u16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Add Wide. This instruction adds the vector elements of the first source SIMD&amp;FP register to the corresponding vector elements in the lower or upper half of the second source SIMD&amp;FP register, places the result in a vector, and writes the vector to the SIMD&amp;FP destination register. The vector elements of the destination register and the first source register are twice as long as the vector elements of the second source register. All the values in this instruction are unsigned integer values.The UADDW instruction extracts vector elements from the lower half of the second source register, while the UADDW2 instruction extracts vector elements from the upper half of the second source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UADDW2 Vd.2D,Vn.2D,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vaddw_high_u32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Add. This instruction adds the values of corresponding elements of the two source SIMD&amp;FP registers, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQADD Bd,Bn,Bm</c></summary>
            [DebuggerStepThrough]
            public static SByte vqaddb_s8(SByte a0, SByte a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Add. This instruction adds the values of corresponding elements of the two source SIMD&amp;FP registers, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQADD Hd,Hn,Hm</c></summary>
            [DebuggerStepThrough]
            public static Int16 vqaddh_s16(Int16 a0, Int16 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Add. This instruction adds the values of corresponding elements of the two source SIMD&amp;FP registers, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQADD Sd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqadds_s32(Int32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Add. This instruction adds the values of corresponding elements of the two source SIMD&amp;FP registers, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQADD Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static Int64 vqaddd_s64(Int64 a0, Int64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Add. This instruction adds the values of corresponding elements of the two source SIMD&amp;FP registers, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQADD Bd,Bn,Bm</c></summary>
            [DebuggerStepThrough]
            public static Byte vqaddb_u8(Byte a0, Byte a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Add. This instruction adds the values of corresponding elements of the two source SIMD&amp;FP registers, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQADD Hd,Hn,Hm</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vqaddh_u16(UInt16 a0, UInt16 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Add. This instruction adds the values of corresponding elements of the two source SIMD&amp;FP registers, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQADD Sd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vqadds_u32(UInt32 a0, UInt32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Add. This instruction adds the values of corresponding elements of the two source SIMD&amp;FP registers, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQADD Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vqaddd_u64(UInt64 a0, UInt64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Accumulate of Unsigned value. This instruction adds the unsigned integer values of the vector elements in the source SIMD&amp;FP register to corresponding signed integer values of the vector elements in the destination SIMD&amp;FP register, and writes the resulting signed integer values to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUQADD Vd.8B,Vn.8B</c></summary>
            [DebuggerStepThrough]
            public static v64 vuqadd_s8(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Accumulate of Unsigned value. This instruction adds the unsigned integer values of the vector elements in the source SIMD&amp;FP register to corresponding signed integer values of the vector elements in the destination SIMD&amp;FP register, and writes the resulting signed integer values to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUQADD Vd.16B,Vn.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vuqaddq_s8(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Accumulate of Unsigned value. This instruction adds the unsigned integer values of the vector elements in the source SIMD&amp;FP register to corresponding signed integer values of the vector elements in the destination SIMD&amp;FP register, and writes the resulting signed integer values to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUQADD Vd.4H,Vn.4H</c></summary>
            [DebuggerStepThrough]
            public static v64 vuqadd_s16(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Accumulate of Unsigned value. This instruction adds the unsigned integer values of the vector elements in the source SIMD&amp;FP register to corresponding signed integer values of the vector elements in the destination SIMD&amp;FP register, and writes the resulting signed integer values to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUQADD Vd.8H,Vn.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vuqaddq_s16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Accumulate of Unsigned value. This instruction adds the unsigned integer values of the vector elements in the source SIMD&amp;FP register to corresponding signed integer values of the vector elements in the destination SIMD&amp;FP register, and writes the resulting signed integer values to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUQADD Vd.2S,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vuqadd_s32(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Accumulate of Unsigned value. This instruction adds the unsigned integer values of the vector elements in the source SIMD&amp;FP register to corresponding signed integer values of the vector elements in the destination SIMD&amp;FP register, and writes the resulting signed integer values to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUQADD Vd.4S,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vuqaddq_s32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Accumulate of Unsigned value. This instruction adds the unsigned integer values of the vector elements in the source SIMD&amp;FP register to corresponding signed integer values of the vector elements in the destination SIMD&amp;FP register, and writes the resulting signed integer values to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUQADD Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vuqadd_s64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Accumulate of Unsigned value. This instruction adds the unsigned integer values of the vector elements in the source SIMD&amp;FP register to corresponding signed integer values of the vector elements in the destination SIMD&amp;FP register, and writes the resulting signed integer values to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUQADD Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vuqaddq_s64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Accumulate of Unsigned value. This instruction adds the unsigned integer values of the vector elements in the source SIMD&amp;FP register to corresponding signed integer values of the vector elements in the destination SIMD&amp;FP register, and writes the resulting signed integer values to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUQADD Bd,Bn</c></summary>
            [DebuggerStepThrough]
            public static SByte vuqaddb_s8(SByte a0, Byte a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Accumulate of Unsigned value. This instruction adds the unsigned integer values of the vector elements in the source SIMD&amp;FP register to corresponding signed integer values of the vector elements in the destination SIMD&amp;FP register, and writes the resulting signed integer values to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUQADD Hd,Hn</c></summary>
            [DebuggerStepThrough]
            public static Int16 vuqaddh_s16(Int16 a0, UInt16 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Accumulate of Unsigned value. This instruction adds the unsigned integer values of the vector elements in the source SIMD&amp;FP register to corresponding signed integer values of the vector elements in the destination SIMD&amp;FP register, and writes the resulting signed integer values to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUQADD Sd,Sn</c></summary>
            [DebuggerStepThrough]
            public static Int32 vuqadds_s32(Int32 a0, UInt32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Accumulate of Unsigned value. This instruction adds the unsigned integer values of the vector elements in the source SIMD&amp;FP register to corresponding signed integer values of the vector elements in the destination SIMD&amp;FP register, and writes the resulting signed integer values to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUQADD Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static Int64 vuqaddd_s64(Int64 a0, UInt64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Accumulate of Signed value. This instruction adds the signed integer values of the vector elements in the source SIMD&amp;FP register to corresponding unsigned integer values of the vector elements in the destination SIMD&amp;FP register, and accumulates the resulting unsigned integer values with the vector elements of the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USQADD Vd.8B,Vn.8B</c></summary>
            [DebuggerStepThrough]
            public static v64 vsqadd_u8(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Accumulate of Signed value. This instruction adds the signed integer values of the vector elements in the source SIMD&amp;FP register to corresponding unsigned integer values of the vector elements in the destination SIMD&amp;FP register, and accumulates the resulting unsigned integer values with the vector elements of the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USQADD Vd.16B,Vn.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vsqaddq_u8(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Accumulate of Signed value. This instruction adds the signed integer values of the vector elements in the source SIMD&amp;FP register to corresponding unsigned integer values of the vector elements in the destination SIMD&amp;FP register, and accumulates the resulting unsigned integer values with the vector elements of the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USQADD Vd.4H,Vn.4H</c></summary>
            [DebuggerStepThrough]
            public static v64 vsqadd_u16(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Accumulate of Signed value. This instruction adds the signed integer values of the vector elements in the source SIMD&amp;FP register to corresponding unsigned integer values of the vector elements in the destination SIMD&amp;FP register, and accumulates the resulting unsigned integer values with the vector elements of the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USQADD Vd.8H,Vn.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vsqaddq_u16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Accumulate of Signed value. This instruction adds the signed integer values of the vector elements in the source SIMD&amp;FP register to corresponding unsigned integer values of the vector elements in the destination SIMD&amp;FP register, and accumulates the resulting unsigned integer values with the vector elements of the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USQADD Vd.2S,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vsqadd_u32(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Accumulate of Signed value. This instruction adds the signed integer values of the vector elements in the source SIMD&amp;FP register to corresponding unsigned integer values of the vector elements in the destination SIMD&amp;FP register, and accumulates the resulting unsigned integer values with the vector elements of the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USQADD Vd.4S,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vsqaddq_u32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Accumulate of Signed value. This instruction adds the signed integer values of the vector elements in the source SIMD&amp;FP register to corresponding unsigned integer values of the vector elements in the destination SIMD&amp;FP register, and accumulates the resulting unsigned integer values with the vector elements of the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USQADD Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vsqadd_u64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Accumulate of Signed value. This instruction adds the signed integer values of the vector elements in the source SIMD&amp;FP register to corresponding unsigned integer values of the vector elements in the destination SIMD&amp;FP register, and accumulates the resulting unsigned integer values with the vector elements of the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USQADD Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vsqaddq_u64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Accumulate of Signed value. This instruction adds the signed integer values of the vector elements in the source SIMD&amp;FP register to corresponding unsigned integer values of the vector elements in the destination SIMD&amp;FP register, and accumulates the resulting unsigned integer values with the vector elements of the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USQADD Bd,Bn</c></summary>
            [DebuggerStepThrough]
            public static Byte vsqaddb_u8(Byte a0, SByte a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Accumulate of Signed value. This instruction adds the signed integer values of the vector elements in the source SIMD&amp;FP register to corresponding unsigned integer values of the vector elements in the destination SIMD&amp;FP register, and accumulates the resulting unsigned integer values with the vector elements of the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USQADD Hd,Hn</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vsqaddh_u16(UInt16 a0, Int16 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Accumulate of Signed value. This instruction adds the signed integer values of the vector elements in the source SIMD&amp;FP register to corresponding unsigned integer values of the vector elements in the destination SIMD&amp;FP register, and accumulates the resulting unsigned integer values with the vector elements of the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USQADD Sd,Sn</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vsqadds_u32(UInt32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Accumulate of Signed value. This instruction adds the signed integer values of the vector elements in the source SIMD&amp;FP register to corresponding unsigned integer values of the vector elements in the destination SIMD&amp;FP register, and accumulates the resulting unsigned integer values with the vector elements of the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USQADD Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vsqaddd_u64(UInt64 a0, Int64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add returning High Narrow. This instruction adds each vector element in the first source SIMD&amp;FP register to the corresponding vector element in the second source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are truncated. For rounded results, see RADDHN.The ADDHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the ADDHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDHN2 Vd.16B,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vaddhn_high_s16(v64 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add returning High Narrow. This instruction adds each vector element in the first source SIMD&amp;FP register to the corresponding vector element in the second source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are truncated. For rounded results, see RADDHN.The ADDHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the ADDHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDHN2 Vd.8H,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vaddhn_high_s32(v64 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add returning High Narrow. This instruction adds each vector element in the first source SIMD&amp;FP register to the corresponding vector element in the second source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are truncated. For rounded results, see RADDHN.The ADDHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the ADDHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDHN2 Vd.4S,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vaddhn_high_s64(v64 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add returning High Narrow. This instruction adds each vector element in the first source SIMD&amp;FP register to the corresponding vector element in the second source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are truncated. For rounded results, see RADDHN.The ADDHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the ADDHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDHN2 Vd.16B,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vaddhn_high_u16(v64 a0, v128 a1, v128 a2)
            {
                return vaddhn_high_s16(a0, a1, a2);
            }

            /// <summary>Add returning High Narrow. This instruction adds each vector element in the first source SIMD&amp;FP register to the corresponding vector element in the second source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are truncated. For rounded results, see RADDHN.The ADDHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the ADDHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDHN2 Vd.8H,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vaddhn_high_u32(v64 a0, v128 a1, v128 a2)
            {
                return vaddhn_high_s32(a0, a1, a2);
            }

            /// <summary>Add returning High Narrow. This instruction adds each vector element in the first source SIMD&amp;FP register to the corresponding vector element in the second source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are truncated. For rounded results, see RADDHN.The ADDHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the ADDHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDHN2 Vd.4S,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vaddhn_high_u64(v64 a0, v128 a1, v128 a2)
            {
                return vaddhn_high_s64(a0, a1, a2);
            }

            /// <summary>Rounding Add returning High Narrow. This instruction adds each vector element in the first source SIMD&amp;FP register to the corresponding vector element in the second source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are rounded. For truncated results, see ADDHN.The RADDHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RADDHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RADDHN2 Vd.16B,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vraddhn_high_s16(v64 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Add returning High Narrow. This instruction adds each vector element in the first source SIMD&amp;FP register to the corresponding vector element in the second source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are rounded. For truncated results, see ADDHN.The RADDHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RADDHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RADDHN2 Vd.8H,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vraddhn_high_s32(v64 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Add returning High Narrow. This instruction adds each vector element in the first source SIMD&amp;FP register to the corresponding vector element in the second source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are rounded. For truncated results, see ADDHN.The RADDHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RADDHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RADDHN2 Vd.4S,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vraddhn_high_s64(v64 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Add returning High Narrow. This instruction adds each vector element in the first source SIMD&amp;FP register to the corresponding vector element in the second source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are rounded. For truncated results, see ADDHN.The RADDHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RADDHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RADDHN2 Vd.16B,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vraddhn_high_u16(v64 a0, v128 a1, v128 a2)
            {
                return vraddhn_high_s16(a0, a1, a2);
            }

            /// <summary>Rounding Add returning High Narrow. This instruction adds each vector element in the first source SIMD&amp;FP register to the corresponding vector element in the second source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are rounded. For truncated results, see ADDHN.The RADDHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RADDHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RADDHN2 Vd.8H,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vraddhn_high_u32(v64 a0, v128 a1, v128 a2)
            {
                return vraddhn_high_s32(a0, a1, a2);
            }

            /// <summary>Rounding Add returning High Narrow. This instruction adds each vector element in the first source SIMD&amp;FP register to the corresponding vector element in the second source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are rounded. For truncated results, see ADDHN.The RADDHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RADDHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RADDHN2 Vd.4S,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vraddhn_high_u64(v64 a0, v128 a1, v128 a2)
            {
                return vraddhn_high_s64(a0, a1, a2);
            }

            /// <summary>Floating-point Multiply (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMUL Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vmul_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMUL Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vmulq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply extended (by element). This instruction multiplies the floating-point values in the vector elements in the first source SIMD&amp;FP register by the specified floating-point value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If one value is zero and the other value is infinite, the result is 2.0. In this case, the result is negative if only one of the values is negative, otherwise the result is positive.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMULX Vd.2S,Vn.2S,Vm.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vmulx_f32(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply extended (by element). This instruction multiplies the floating-point values in the vector elements in the first source SIMD&amp;FP register by the specified floating-point value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If one value is zero and the other value is infinite, the result is 2.0. In this case, the result is negative if only one of the values is negative, otherwise the result is positive.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMULX Vd.4S,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vmulxq_f32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply extended (by element). This instruction multiplies the floating-point values in the vector elements in the first source SIMD&amp;FP register by the specified floating-point value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If one value is zero and the other value is infinite, the result is 2.0. In this case, the result is negative if only one of the values is negative, otherwise the result is positive.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMULX Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vmulx_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply extended (by element). This instruction multiplies the floating-point values in the vector elements in the first source SIMD&amp;FP register by the specified floating-point value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If one value is zero and the other value is infinite, the result is 2.0. In this case, the result is negative if only one of the values is negative, otherwise the result is positive.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMULX Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vmulxq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply extended (by element). This instruction multiplies the floating-point values in the vector elements in the first source SIMD&amp;FP register by the specified floating-point value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If one value is zero and the other value is infinite, the result is 2.0. In this case, the result is negative if only one of the values is negative, otherwise the result is positive.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMULX Sd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static Single vmulxs_f32(Single a0, Single a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply extended (by element). This instruction multiplies the floating-point values in the vector elements in the first source SIMD&amp;FP register by the specified floating-point value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If one value is zero and the other value is infinite, the result is 2.0. In this case, the result is negative if only one of the values is negative, otherwise the result is positive.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMULX Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static Double vmulxd_f64(Double a0, Double a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply extended (by element). This instruction multiplies the floating-point values in the vector elements in the first source SIMD&amp;FP register by the specified floating-point value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If one value is zero and the other value is infinite, the result is 2.0. In this case, the result is negative if only one of the values is negative, otherwise the result is positive.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMULX Vd.2S,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmulx_lane_f32(v64 a0, v64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply extended (by element). This instruction multiplies the floating-point values in the vector elements in the first source SIMD&amp;FP register by the specified floating-point value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If one value is zero and the other value is infinite, the result is 2.0. In this case, the result is negative if only one of the values is negative, otherwise the result is positive.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMULX Vd.4S,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmulxq_lane_f32(v128 a0, v64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply extended (by element). This instruction multiplies the floating-point values in the vector elements in the first source SIMD&amp;FP register by the specified floating-point value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If one value is zero and the other value is infinite, the result is 2.0. In this case, the result is negative if only one of the values is negative, otherwise the result is positive.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMULX Dd,Dn,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmulx_lane_f64(v64 a0, v64 a1, Int32 a2)
            {
                return vmulx_f64(a0, a1);
            }

            /// <summary>Floating-point Multiply extended (by element). This instruction multiplies the floating-point values in the vector elements in the first source SIMD&amp;FP register by the specified floating-point value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If one value is zero and the other value is infinite, the result is 2.0. In this case, the result is negative if only one of the values is negative, otherwise the result is positive.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMULX Vd.2D,Vn.2D,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmulxq_lane_f64(v128 a0, v64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply extended (by element). This instruction multiplies the floating-point values in the vector elements in the first source SIMD&amp;FP register by the specified floating-point value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If one value is zero and the other value is infinite, the result is 2.0. In this case, the result is negative if only one of the values is negative, otherwise the result is positive.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMULX Sd,Sn,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Single vmulxs_lane_f32(Single a0, v64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply extended (by element). This instruction multiplies the floating-point values in the vector elements in the first source SIMD&amp;FP register by the specified floating-point value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If one value is zero and the other value is infinite, the result is 2.0. In this case, the result is negative if only one of the values is negative, otherwise the result is positive.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMULX Dd,Dn,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static Double vmulxd_lane_f64(Double a0, v64 a1, Int32 a2)
            {
                return vmulxd_f64(a0, a1.Double0);
            }

            /// <summary>Floating-point Multiply extended (by element). This instruction multiplies the floating-point values in the vector elements in the first source SIMD&amp;FP register by the specified floating-point value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If one value is zero and the other value is infinite, the result is 2.0. In this case, the result is negative if only one of the values is negative, otherwise the result is positive.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMULX Vd.2S,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmulx_laneq_f32(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply extended (by element). This instruction multiplies the floating-point values in the vector elements in the first source SIMD&amp;FP register by the specified floating-point value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If one value is zero and the other value is infinite, the result is 2.0. In this case, the result is negative if only one of the values is negative, otherwise the result is positive.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMULX Vd.4S,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmulxq_laneq_f32(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply extended (by element). This instruction multiplies the floating-point values in the vector elements in the first source SIMD&amp;FP register by the specified floating-point value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If one value is zero and the other value is infinite, the result is 2.0. In this case, the result is negative if only one of the values is negative, otherwise the result is positive.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMULX Dd,Dn,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmulx_laneq_f64(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply extended (by element). This instruction multiplies the floating-point values in the vector elements in the first source SIMD&amp;FP register by the specified floating-point value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If one value is zero and the other value is infinite, the result is 2.0. In this case, the result is negative if only one of the values is negative, otherwise the result is positive.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMULX Vd.2D,Vn.2D,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmulxq_laneq_f64(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply extended (by element). This instruction multiplies the floating-point values in the vector elements in the first source SIMD&amp;FP register by the specified floating-point value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If one value is zero and the other value is infinite, the result is 2.0. In this case, the result is negative if only one of the values is negative, otherwise the result is positive.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMULX Sd,Sn,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Single vmulxs_laneq_f32(Single a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply extended (by element). This instruction multiplies the floating-point values in the vector elements in the first source SIMD&amp;FP register by the specified floating-point value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If one value is zero and the other value is infinite, the result is 2.0. In this case, the result is negative if only one of the values is negative, otherwise the result is positive.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMULX Dd,Dn,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static Double vmulxd_laneq_f64(Double a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Divide (vector). This instruction divides the floating-point values in the elements in the first source SIMD&amp;FP register, by the floating-point values in the corresponding elements in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FDIV Vd.2S,Vn.2S,Vm.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vdiv_f32(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Divide (vector). This instruction divides the floating-point values in the elements in the first source SIMD&amp;FP register, by the floating-point values in the corresponding elements in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FDIV Vd.4S,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vdivq_f32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Divide (vector). This instruction divides the floating-point values in the elements in the first source SIMD&amp;FP register, by the floating-point values in the corresponding elements in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FDIV Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vdiv_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Divide (vector). This instruction divides the floating-point values in the elements in the first source SIMD&amp;FP register, by the floating-point values in the corresponding elements in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FDIV Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vdivq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>
            /// <br/>Equivalent instruction: <c>RESULT[I] = a[i] + (b[i] * c[i]) for i = 0</c></summary>
            [DebuggerStepThrough]
            public static v64 vmla_f64(v64 a0, v64 a1, v64 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>
            /// <br/>Equivalent instruction: <c>RESULT[I] = a[i] + (b[i] * c[i]) for i = 0 to 1</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlaq_f64(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element in the second source SIMD&amp;FP register, and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.The SMLAL instruction extracts vector elements from the lower half of the first source register, while the SMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLAL2 Vd.8H,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_high_s8(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element in the second source SIMD&amp;FP register, and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.The SMLAL instruction extracts vector elements from the lower half of the first source register, while the SMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLAL2 Vd.4S,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_high_s16(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element in the second source SIMD&amp;FP register, and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.The SMLAL instruction extracts vector elements from the lower half of the first source register, while the SMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLAL2 Vd.2D,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_high_s32(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLAL instruction extracts vector elements from the lower half of the first source register, while the UMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLAL2 Vd.8H,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_high_u8(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLAL instruction extracts vector elements from the lower half of the first source register, while the UMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLAL2 Vd.4S,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_high_u16(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLAL instruction extracts vector elements from the lower half of the first source register, while the UMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLAL2 Vd.2D,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_high_u32(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>
            /// <br/>Equivalent instruction: <c>RESULT[I] = a[i] - (b[i] * c[i]) for i = 0</c></summary>
            [DebuggerStepThrough]
            public static v64 vmls_f64(v64 a0, v64 a1, v64 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>
            /// <br/>Equivalent instruction: <c>RESULT[I] = a[i] - (b[i] * c[i]) for i = 0 to 1</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsq_f64(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMLSL instruction extracts vector elements from the lower half of the first source register, while the SMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLSL2 Vd.8H,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_high_s8(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMLSL instruction extracts vector elements from the lower half of the first source register, while the SMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLSL2 Vd.4S,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_high_s16(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMLSL instruction extracts vector elements from the lower half of the first source register, while the SMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLSL2 Vd.2D,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_high_s32(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLSL instruction extracts vector elements from the lower half of the first source register, while the UMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLSL2 Vd.8H,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_high_u8(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLSL instruction extracts vector elements from the lower half of the first source register, while the UMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLSL2 Vd.4S,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_high_u16(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLSL instruction extracts vector elements from the lower half of the first source register, while the UMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLSL2 Vd.2D,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_high_u32(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Add (scalar). This instruction multiplies the values of the first two SIMD&amp;FP source registers, adds the product to the value of the third SIMD&amp;FP source register, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMADD Dd,Dn,Dm,Da</c></summary>
            [DebuggerStepThrough]
            public static v64 vfma_f64(v64 a0, v64 a1, v64 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Add to accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results in the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLA Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vfmaq_f64(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Add to accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results in the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLA Vd.2S,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vfma_lane_f32(v64 a0, v64 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Add to accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results in the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLA Vd.4S,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vfmaq_lane_f32(v128 a0, v128 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Add to accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results in the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLA Dd,Dn,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vfma_lane_f64(v64 a0, v64 a1, v64 a2, Int32 a3)
            {
                return vfma_f64(a0, a1, a2);
            }

            /// <summary>Floating-point fused Multiply-Add to accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results in the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLA Vd.2D,Vn.2D,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vfmaq_lane_f64(v128 a0, v128 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Add to accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results in the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLA Sd,Sn,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Single vfmas_lane_f32(Single a0, Single a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Add to accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results in the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLA Dd,Dn,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static Double vfmad_lane_f64(Double a0, Double a1, v64 a2, Int32 a3)
            {
                return vfma_f64(new v64(a0), new v64(a1), a2).Double0;
            }

            /// <summary>Floating-point fused Multiply-Add to accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results in the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLA Vd.2S,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vfma_laneq_f32(v64 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Add to accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results in the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLA Vd.4S,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vfmaq_laneq_f32(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Add to accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results in the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLA Dd,Dn,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vfma_laneq_f64(v64 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Add to accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results in the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLA Vd.2D,Vn.2D,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vfmaq_laneq_f64(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Add to accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results in the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLA Sd,Sn,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Single vfmas_laneq_f32(Single a0, Single a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Add to accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results in the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLA Dd,Dn,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static Double vfmad_laneq_f64(Double a0, Double a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Fused Multiply-Subtract (scalar). This instruction multiplies the values of the first two SIMD&amp;FP source registers, negates the product, adds that to the value of the third SIMD&amp;FP source register, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMSUB Dd,Dn,Dm,Da</c></summary>
            [DebuggerStepThrough]
            public static v64 vfms_f64(v64 a0, v64 a1, v64 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Subtract from accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLS Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vfmsq_f64(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Subtract from accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLS Vd.2S,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vfms_lane_f32(v64 a0, v64 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Subtract from accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLS Vd.4S,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vfmsq_lane_f32(v128 a0, v128 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Subtract from accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLS Dd,Dn,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vfms_lane_f64(v64 a0, v64 a1, v64 a2, Int32 a3)
            {
                return vfms_f64(a0, a1, a2);
            }

            /// <summary>Floating-point fused Multiply-Subtract from accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLS Vd.2D,Vn.2D,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vfmsq_lane_f64(v128 a0, v128 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Subtract from accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLS Sd,Sn,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Single vfmss_lane_f32(Single a0, Single a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Subtract from accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLS Dd,Dn,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static Double vfmsd_lane_f64(Double a0, Double a1, v64 a2, Int32 a3)
            {
                return vfms_f64(new v64(a0), new v64(a1), a2).Double0;
            }

            /// <summary>Floating-point fused Multiply-Subtract from accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLS Vd.2S,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vfms_laneq_f32(v64 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Subtract from accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLS Vd.4S,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vfmsq_laneq_f32(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Subtract from accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLS Dd,Dn,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vfms_laneq_f64(v64 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Subtract from accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLS Vd.2D,Vn.2D,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vfmsq_laneq_f64(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Subtract from accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLS Sd,Sn,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Single vfmss_laneq_f32(Single a0, Single a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point fused Multiply-Subtract from accumulator (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMLS Dd,Dn,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static Double vfmsd_laneq_f64(Double a0, Double a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are truncated. For rounded results, see SQRDMULH.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULH Hd,Hn,Hm</c></summary>
            [DebuggerStepThrough]
            public static Int16 vqdmulhh_s16(Int16 a0, Int16 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are truncated. For rounded results, see SQRDMULH.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULH Sd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqdmulhs_s32(Int32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounding Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SQDMULH.If any of the results overflows, they are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRDMULH Hd,Hn,Hm</c></summary>
            [DebuggerStepThrough]
            public static Int16 vqrdmulhh_s16(Int16 a0, Int16 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounding Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SQDMULH.If any of the results overflows, they are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRDMULH Sd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqrdmulhs_s32(Int32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Add Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLAL instruction extracts vector elements from the lower half of the first source register, while the SQDMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLAL Sd,Hn,Hm</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqdmlalh_s16(Int32 a0, Int16 a1, Int16 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Add Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLAL instruction extracts vector elements from the lower half of the first source register, while the SQDMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLAL Dd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static Int64 vqdmlals_s32(Int64 a0, Int32 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Add Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLAL instruction extracts vector elements from the lower half of the first source register, while the SQDMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLAL2 Vd.4S,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlal_high_s16(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Add Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLAL instruction extracts vector elements from the lower half of the first source register, while the SQDMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLAL2 Vd.2D,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlal_high_s32(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Subtract Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and subtracts the final results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLSL instruction extracts vector elements from the lower half of the first source register, while the SQDMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLSL Sd,Hn,Hm</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqdmlslh_s16(Int32 a0, Int16 a1, Int16 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Subtract Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and subtracts the final results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLSL instruction extracts vector elements from the lower half of the first source register, while the SQDMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLSL Dd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static Int64 vqdmlsls_s32(Int64 a0, Int32 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Subtract Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and subtracts the final results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLSL instruction extracts vector elements from the lower half of the first source register, while the SQDMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLSL2 Vd.4S,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlsl_high_s16(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Subtract Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and subtracts the final results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLSL instruction extracts vector elements from the lower half of the first source register, while the SQDMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLSL2 Vd.2D,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlsl_high_s32(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMULL instruction extracts vector elements from the lower half of the first source register, while the SMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMULL2 Vd.8H,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_high_s8(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMULL instruction extracts vector elements from the lower half of the first source register, while the SMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMULL2 Vd.4S,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_high_s16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMULL instruction extracts vector elements from the lower half of the first source register, while the SMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMULL2 Vd.2D,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_high_s32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMULL instruction extracts vector elements from the lower half of the first source register, while the UMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMULL2 Vd.8H,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_high_u8(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMULL instruction extracts vector elements from the lower half of the first source register, while the UMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMULL2 Vd.4S,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_high_u16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMULL instruction extracts vector elements from the lower half of the first source register, while the UMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMULL2 Vd.2D,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_high_u32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the final results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMULL instruction extracts the first source vector from the lower half of the first source register, while the SQDMULL2 instruction extracts the first source vector from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULL Sd,Hn,Hm</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqdmullh_s16(Int16 a0, Int16 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the final results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMULL instruction extracts the first source vector from the lower half of the first source register, while the SQDMULL2 instruction extracts the first source vector from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULL Dd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static Int64 vqdmulls_s32(Int32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the final results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMULL instruction extracts the first source vector from the lower half of the first source register, while the SQDMULL2 instruction extracts the first source vector from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULL2 Vd.4S,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmull_high_s16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the final results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMULL instruction extracts the first source vector from the lower half of the first source register, while the SQDMULL2 instruction extracts the first source vector from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULL2 Vd.2D,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmull_high_s32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Subtract (vector). This instruction subtracts the elements in the vector in the second source SIMD&amp;FP register, from the corresponding elements in the vector in the first source SIMD&amp;FP register, places each result into elements of a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FSUB Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vsub_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Subtract (vector). This instruction subtracts the elements in the vector in the second source SIMD&amp;FP register, from the corresponding elements in the vector in the first source SIMD&amp;FP register, places each result into elements of a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FSUB Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vsubq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Subtract (vector). This instruction subtracts each vector element in the second source SIMD&amp;FP register from the corresponding vector element in the first source SIMD&amp;FP register, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUB Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static Int64 vsubd_s64(Int64 a0, Int64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Subtract (vector). This instruction subtracts each vector element in the second source SIMD&amp;FP register from the corresponding vector element in the first source SIMD&amp;FP register, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUB Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vsubd_u64(UInt64 a0, UInt64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Subtract Long. This instruction subtracts each vector element in the lower or upper half of the second source SIMD&amp;FP register from the corresponding vector element of the first source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values. The destination vector elements are twice as long as the source vector elements.The SSUBL instruction extracts each source vector from the lower half of each source register, while the SSUBL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SSUBL2 Vd.8H,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vsubl_high_s8(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Subtract Long. This instruction subtracts each vector element in the lower or upper half of the second source SIMD&amp;FP register from the corresponding vector element of the first source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values. The destination vector elements are twice as long as the source vector elements.The SSUBL instruction extracts each source vector from the lower half of each source register, while the SSUBL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SSUBL2 Vd.4S,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vsubl_high_s16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Subtract Long. This instruction subtracts each vector element in the lower or upper half of the second source SIMD&amp;FP register from the corresponding vector element of the first source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values. The destination vector elements are twice as long as the source vector elements.The SSUBL instruction extracts each source vector from the lower half of each source register, while the SSUBL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SSUBL2 Vd.2D,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vsubl_high_s32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Subtract Long. This instruction subtracts each vector element in the lower or upper half of the second source SIMD&amp;FP register from the corresponding vector element of the first source SIMD&amp;FP register, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values. The destination vector elements are twice as long as the source vector elements.The USUBL instruction extracts each source vector from the lower half of each source register, while the USUBL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USUBL2 Vd.8H,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vsubl_high_u8(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Subtract Long. This instruction subtracts each vector element in the lower or upper half of the second source SIMD&amp;FP register from the corresponding vector element of the first source SIMD&amp;FP register, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values. The destination vector elements are twice as long as the source vector elements.The USUBL instruction extracts each source vector from the lower half of each source register, while the USUBL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USUBL2 Vd.4S,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vsubl_high_u16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Subtract Long. This instruction subtracts each vector element in the lower or upper half of the second source SIMD&amp;FP register from the corresponding vector element of the first source SIMD&amp;FP register, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values. The destination vector elements are twice as long as the source vector elements.The USUBL instruction extracts each source vector from the lower half of each source register, while the USUBL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USUBL2 Vd.2D,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vsubl_high_u32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Subtract Wide. This instruction subtracts each vector element in the lower or upper half of the second source SIMD&amp;FP register from the corresponding vector element in the first source SIMD&amp;FP register, places the result in a vector, and writes the vector to the SIMD&amp;FP destination register. All the values in this instruction are signed integer values.The SSUBW instruction extracts the second source vector from the lower half of the second source register, while the SSUBW2 instruction extracts the second source vector from the upper half of the second source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SSUBW2 Vd.8H,Vn.8H,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vsubw_high_s8(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Subtract Wide. This instruction subtracts each vector element in the lower or upper half of the second source SIMD&amp;FP register from the corresponding vector element in the first source SIMD&amp;FP register, places the result in a vector, and writes the vector to the SIMD&amp;FP destination register. All the values in this instruction are signed integer values.The SSUBW instruction extracts the second source vector from the lower half of the second source register, while the SSUBW2 instruction extracts the second source vector from the upper half of the second source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SSUBW2 Vd.4S,Vn.4S,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vsubw_high_s16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Subtract Wide. This instruction subtracts each vector element in the lower or upper half of the second source SIMD&amp;FP register from the corresponding vector element in the first source SIMD&amp;FP register, places the result in a vector, and writes the vector to the SIMD&amp;FP destination register. All the values in this instruction are signed integer values.The SSUBW instruction extracts the second source vector from the lower half of the second source register, while the SSUBW2 instruction extracts the second source vector from the upper half of the second source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SSUBW2 Vd.2D,Vn.2D,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vsubw_high_s32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Subtract Wide. This instruction subtracts each vector element of the second source SIMD&amp;FP register from the corresponding vector element in the lower or upper half of the first source SIMD&amp;FP register, places the result in a vector, and writes the vector to the SIMD&amp;FP destination register. All the values in this instruction are signed integer values.The vector elements of the destination register and the first source register are twice as long as the vector elements of the second source register.The USUBW instruction extracts vector elements from the lower half of the first source register, while the USUBW2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USUBW2 Vd.8H,Vn.8H,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vsubw_high_u8(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Subtract Wide. This instruction subtracts each vector element of the second source SIMD&amp;FP register from the corresponding vector element in the lower or upper half of the first source SIMD&amp;FP register, places the result in a vector, and writes the vector to the SIMD&amp;FP destination register. All the values in this instruction are signed integer values.The vector elements of the destination register and the first source register are twice as long as the vector elements of the second source register.The USUBW instruction extracts vector elements from the lower half of the first source register, while the USUBW2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USUBW2 Vd.4S,Vn.4S,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vsubw_high_u16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Subtract Wide. This instruction subtracts each vector element of the second source SIMD&amp;FP register from the corresponding vector element in the lower or upper half of the first source SIMD&amp;FP register, places the result in a vector, and writes the vector to the SIMD&amp;FP destination register. All the values in this instruction are signed integer values.The vector elements of the destination register and the first source register are twice as long as the vector elements of the second source register.The USUBW instruction extracts vector elements from the lower half of the first source register, while the USUBW2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USUBW2 Vd.2D,Vn.2D,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vsubw_high_u32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Subtract. This instruction subtracts the element values of the second source SIMD&amp;FP register from the corresponding element values of the first source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSUB Bd,Bn,Bm</c></summary>
            [DebuggerStepThrough]
            public static SByte vqsubb_s8(SByte a0, SByte a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Subtract. This instruction subtracts the element values of the second source SIMD&amp;FP register from the corresponding element values of the first source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSUB Hd,Hn,Hm</c></summary>
            [DebuggerStepThrough]
            public static Int16 vqsubh_s16(Int16 a0, Int16 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Subtract. This instruction subtracts the element values of the second source SIMD&amp;FP register from the corresponding element values of the first source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSUB Sd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqsubs_s32(Int32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Subtract. This instruction subtracts the element values of the second source SIMD&amp;FP register from the corresponding element values of the first source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSUB Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static Int64 vqsubd_s64(Int64 a0, Int64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Subtract. This instruction subtracts the element values of the second source SIMD&amp;FP register from the corresponding element values of the first source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQSUB Bd,Bn,Bm</c></summary>
            [DebuggerStepThrough]
            public static Byte vqsubb_u8(Byte a0, Byte a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Subtract. This instruction subtracts the element values of the second source SIMD&amp;FP register from the corresponding element values of the first source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQSUB Hd,Hn,Hm</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vqsubh_u16(UInt16 a0, UInt16 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Subtract. This instruction subtracts the element values of the second source SIMD&amp;FP register from the corresponding element values of the first source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQSUB Sd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vqsubs_u32(UInt32 a0, UInt32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Subtract. This instruction subtracts the element values of the second source SIMD&amp;FP register from the corresponding element values of the first source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQSUB Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vqsubd_u64(UInt64 a0, UInt64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Subtract returning High Narrow. This instruction subtracts each vector element of the second source SIMD&amp;FP register from the corresponding vector element of the first source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SUBHN.The RSUBHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSUBHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUBHN2 Vd.16B,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vsubhn_high_s16(v64 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Subtract returning High Narrow. This instruction subtracts each vector element of the second source SIMD&amp;FP register from the corresponding vector element of the first source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SUBHN.The RSUBHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSUBHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUBHN2 Vd.8H,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vsubhn_high_s32(v64 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Subtract returning High Narrow. This instruction subtracts each vector element of the second source SIMD&amp;FP register from the corresponding vector element of the first source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SUBHN.The RSUBHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSUBHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUBHN2 Vd.4S,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vsubhn_high_s64(v64 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Subtract returning High Narrow. This instruction subtracts each vector element of the second source SIMD&amp;FP register from the corresponding vector element of the first source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SUBHN.The RSUBHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSUBHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUBHN2 Vd.16B,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vsubhn_high_u16(v64 a0, v128 a1, v128 a2)
            {
                return vsubhn_high_s16(a0, a1, a2);
            }

            /// <summary>Rounding Subtract returning High Narrow. This instruction subtracts each vector element of the second source SIMD&amp;FP register from the corresponding vector element of the first source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SUBHN.The RSUBHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSUBHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUBHN2 Vd.8H,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vsubhn_high_u32(v64 a0, v128 a1, v128 a2)
            {
                return vsubhn_high_s32(a0, a1, a2);
            }

            /// <summary>Rounding Subtract returning High Narrow. This instruction subtracts each vector element of the second source SIMD&amp;FP register from the corresponding vector element of the first source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SUBHN.The RSUBHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSUBHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SUBHN2 Vd.4S,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vsubhn_high_u64(v64 a0, v128 a1, v128 a2)
            {
                return vsubhn_high_s64(a0, a1, a2);
            }

            /// <summary>Rounding Subtract returning High Narrow. This instruction subtracts each vector element of the second source SIMD&amp;FP register from the corresponding vector element of the first source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SUBHN.The RSUBHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSUBHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RSUBHN2 Vd.16B,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vrsubhn_high_s16(v64 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Subtract returning High Narrow. This instruction subtracts each vector element of the second source SIMD&amp;FP register from the corresponding vector element of the first source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SUBHN.The RSUBHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSUBHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RSUBHN2 Vd.8H,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vrsubhn_high_s32(v64 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Subtract returning High Narrow. This instruction subtracts each vector element of the second source SIMD&amp;FP register from the corresponding vector element of the first source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SUBHN.The RSUBHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSUBHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RSUBHN2 Vd.4S,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vrsubhn_high_s64(v64 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Subtract returning High Narrow. This instruction subtracts each vector element of the second source SIMD&amp;FP register from the corresponding vector element of the first source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SUBHN.The RSUBHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSUBHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RSUBHN2 Vd.16B,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vrsubhn_high_u16(v64 a0, v128 a1, v128 a2)
            {
                return vrsubhn_high_s16(a0, a1, a2);
            }

            /// <summary>Rounding Subtract returning High Narrow. This instruction subtracts each vector element of the second source SIMD&amp;FP register from the corresponding vector element of the first source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SUBHN.The RSUBHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSUBHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RSUBHN2 Vd.8H,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vrsubhn_high_u32(v64 a0, v128 a1, v128 a2)
            {
                return vrsubhn_high_s32(a0, a1, a2);
            }

            /// <summary>Rounding Subtract returning High Narrow. This instruction subtracts each vector element of the second source SIMD&amp;FP register from the corresponding vector element of the first source SIMD&amp;FP register, places the most significant half of the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SUBHN.The RSUBHN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSUBHN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RSUBHN2 Vd.4S,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vrsubhn_high_u64(v64 a0, v128 a1, v128 a2)
            {
                return vrsubhn_high_s64(a0, a1, a2);
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vceq_s64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vceqq_s64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vceq_u64(v64 a0, v64 a1)
            {
                return vceq_s64(a0, a1);
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vceqq_u64(v128 a0, v128 a1)
            {
                return vceqq_s64(a0, a1);
            }

            /// <summary>Floating-point Compare Equal (vector). This instruction compares each floating-point value from the first source SIMD&amp;FP register, with the corresponding floating-point value from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMEQ Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vceq_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Equal (vector). This instruction compares each floating-point value from the first source SIMD&amp;FP register, with the corresponding floating-point value from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMEQ Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vceqq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vceqd_s64(Int64 a0, Int64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vceqd_u64(UInt64 a0, UInt64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Equal (vector). This instruction compares each floating-point value from the first source SIMD&amp;FP register, with the corresponding floating-point value from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMEQ Sd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vceqs_f32(Single a0, Single a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Equal (vector). This instruction compares each floating-point value from the first source SIMD&amp;FP register, with the corresponding floating-point value from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMEQ Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vceqd_f64(Double a0, Double a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Vd.8B,Vn.8B,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vceqz_s8(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Vd.16B,Vn.16B,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vceqzq_s8(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Vd.4H,Vn.4H,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vceqz_s16(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Vd.8H,Vn.8H,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vceqzq_s16(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Vd.2S,Vn.2S,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vceqz_s32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Vd.4S,Vn.4S,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vceqzq_s32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Vd.8B,Vn.8B,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vceqz_u8(v64 a0)
            {
                return vceqz_s8(a0);
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Vd.16B,Vn.16B,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vceqzq_u8(v128 a0)
            {
                return vceqzq_s8(a0);
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Vd.4H,Vn.4H,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vceqz_u16(v64 a0)
            {
                return vceqz_s16(a0);
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Vd.8H,Vn.8H,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vceqzq_u16(v128 a0)
            {
                return vceqzq_s16(a0);
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Vd.2S,Vn.2S,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vceqz_u32(v64 a0)
            {
                return vceqz_s32(a0);
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Vd.4S,Vn.4S,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vceqzq_u32(v128 a0)
            {
                return vceqzq_s32(a0);
            }

            /// <summary>Floating-point Compare Equal (vector). This instruction compares each floating-point value from the first source SIMD&amp;FP register, with the corresponding floating-point value from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMEQ Vd.2S,Vn.2S,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vceqz_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Equal (vector). This instruction compares each floating-point value from the first source SIMD&amp;FP register, with the corresponding floating-point value from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMEQ Vd.4S,Vn.4S,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vceqzq_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vceqz_s64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Vd.2D,Vn.2D,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vceqzq_s64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vceqz_u64(v64 a0)
            {
                return vceqz_s64(a0);
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Vd.2D,Vn.2D,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vceqzq_u64(v128 a0)
            {
                return vceqzq_s64(a0);
            }

            /// <summary>Floating-point Compare Equal (vector). This instruction compares each floating-point value from the first source SIMD&amp;FP register, with the corresponding floating-point value from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMEQ Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vceqz_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Equal (vector). This instruction compares each floating-point value from the first source SIMD&amp;FP register, with the corresponding floating-point value from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMEQ Vd.2D,Vn.2D,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vceqzq_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vceqzd_s64(Int64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Equal (vector). This instruction compares each vector element from the first source SIMD&amp;FP register with the corresponding vector element from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMEQ Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vceqzd_u64(UInt64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Equal (vector). This instruction compares each floating-point value from the first source SIMD&amp;FP register, with the corresponding floating-point value from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMEQ Sd,Sn,#0</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vceqzs_f32(Single a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Equal (vector). This instruction compares each floating-point value from the first source SIMD&amp;FP register, with the corresponding floating-point value from the second source SIMD&amp;FP register, and if the comparison is equal sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMEQ Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vceqzd_f64(Double a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than or Equal (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than or equal to the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGE Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vcge_s64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than or Equal (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than or equal to the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGE Vd.2D,Vm.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcgeq_s64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare unsigned Higher or Same (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first unsigned integer value is greater than or equal to the second unsigned integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMHS Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vcge_u64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare unsigned Higher or Same (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first unsigned integer value is greater than or equal to the second unsigned integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMHS Vd.2D,Vm.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcgeq_u64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than or Equal (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than or equal to the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGE Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vcge_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than or Equal (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than or equal to the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGE Vd.2D,Vm.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcgeq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than or Equal (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than or equal to the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGE Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcged_s64(Int64 a0, Int64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare unsigned Higher or Same (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first unsigned integer value is greater than or equal to the second unsigned integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMHS Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcged_u64(UInt64 a0, UInt64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than or Equal (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than or equal to the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGE Sd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vcges_f32(Single a0, Single a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than or Equal (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than or equal to the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGE Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcged_f64(Double a0, Double a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than or Equal (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than or equal to the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGE Vd.8B,Vn.8B,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vcgez_s8(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than or Equal (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than or equal to the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGE Vd.16B,Vn.16B,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vcgezq_s8(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than or Equal (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than or equal to the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGE Vd.4H,Vn.4H,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vcgez_s16(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than or Equal (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than or equal to the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGE Vd.8H,Vn.8H,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vcgezq_s16(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than or Equal (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than or equal to the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGE Vd.2S,Vn.2S,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vcgez_s32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than or Equal (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than or equal to the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGE Vd.4S,Vn.4S,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vcgezq_s32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than or Equal (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than or equal to the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGE Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vcgez_s64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than or Equal (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than or equal to the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGE Vd.2D,Vn.2D,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vcgezq_s64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than or Equal (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than or equal to the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGE Vd.2S,Vn.2S,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vcgez_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than or Equal (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than or equal to the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGE Vd.4S,Vn.4S,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vcgezq_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than or Equal (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than or equal to the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGE Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vcgez_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than or Equal (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than or equal to the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGE Vd.2D,Vn.2D,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vcgezq_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than or Equal (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than or equal to the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGE Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcgezd_s64(Int64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than or Equal (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than or equal to the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGE Sd,Sn,#0</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vcgezs_f32(Single a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than or Equal (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than or equal to the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGE Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcgezd_f64(Double a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than or Equal (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than or equal to the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGE Dd,Dm,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vcle_s64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than or Equal (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than or equal to the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGE Vd.2D,Vm.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcleq_s64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare unsigned Higher or Same (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first unsigned integer value is greater than or equal to the second unsigned integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMHS Dd,Dm,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vcle_u64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare unsigned Higher or Same (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first unsigned integer value is greater than or equal to the second unsigned integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMHS Vd.2D,Vm.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcleq_u64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than or Equal (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than or equal to the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGE Dd,Dm,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vcle_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than or Equal (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than or equal to the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGE Vd.2D,Vm.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcleq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than or Equal (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than or equal to the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGE Dd,Dm,Dn</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcled_s64(Int64 a0, Int64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare unsigned Higher or Same (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first unsigned integer value is greater than or equal to the second unsigned integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMHS Dd,Dm,Dn</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcled_u64(UInt64 a0, UInt64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than or Equal (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than or equal to the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGE Sd,Sm,Sn</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vcles_f32(Single a0, Single a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than or Equal (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than or equal to the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGE Dd,Dm,Dn</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcled_f64(Double a0, Double a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Less than or Equal to zero (vector). This instruction reads each vector element in the source SIMD&amp;FP register and if the signed integer value is less than or equal to zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMLE Vd.8B,Vn.8B,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vclez_s8(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Less than or Equal to zero (vector). This instruction reads each vector element in the source SIMD&amp;FP register and if the signed integer value is less than or equal to zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMLE Vd.16B,Vn.16B,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vclezq_s8(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Less than or Equal to zero (vector). This instruction reads each vector element in the source SIMD&amp;FP register and if the signed integer value is less than or equal to zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMLE Vd.4H,Vn.4H,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vclez_s16(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Less than or Equal to zero (vector). This instruction reads each vector element in the source SIMD&amp;FP register and if the signed integer value is less than or equal to zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMLE Vd.8H,Vn.8H,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vclezq_s16(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Less than or Equal to zero (vector). This instruction reads each vector element in the source SIMD&amp;FP register and if the signed integer value is less than or equal to zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMLE Vd.2S,Vn.2S,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vclez_s32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Less than or Equal to zero (vector). This instruction reads each vector element in the source SIMD&amp;FP register and if the signed integer value is less than or equal to zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMLE Vd.4S,Vn.4S,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vclezq_s32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Less than or Equal to zero (vector). This instruction reads each vector element in the source SIMD&amp;FP register and if the signed integer value is less than or equal to zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMLE Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vclez_s64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Less than or Equal to zero (vector). This instruction reads each vector element in the source SIMD&amp;FP register and if the signed integer value is less than or equal to zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMLE Vd.2D,Vn.2D,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vclezq_s64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Less than or Equal to zero (vector). This instruction reads each vector element in the source SIMD&amp;FP register and if the signed integer value is less than or equal to zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMLE Vd.2S,Vn.2S,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vclez_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Less than or Equal to zero (vector). This instruction reads each floating-point value in the source SIMD&amp;FP register and if the value is less than or equal to zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMLE Vd.4S,Vn.4S,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vclezq_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Less than or Equal to zero (vector). This instruction reads each floating-point value in the source SIMD&amp;FP register and if the value is less than or equal to zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMLE Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vclez_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Less than or Equal to zero (vector). This instruction reads each floating-point value in the source SIMD&amp;FP register and if the value is less than or equal to zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMLE Vd.2D,Vn.2D,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vclezq_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Less than or Equal to zero (vector). This instruction reads each vector element in the source SIMD&amp;FP register and if the signed integer value is less than or equal to zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMLE Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vclezd_s64(Int64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Less than or Equal to zero (vector). This instruction reads each floating-point value in the source SIMD&amp;FP register and if the value is less than or equal to zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMLE Sd,Sn,#0</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vclezs_f32(Single a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Less than or Equal to zero (vector). This instruction reads each floating-point value in the source SIMD&amp;FP register and if the value is less than or equal to zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMLE Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vclezd_f64(Double a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGT Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vcgt_s64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGT Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcgtq_s64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare unsigned Higher (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first unsigned integer value is greater than the second unsigned integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMHI Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vcgt_u64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare unsigned Higher (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first unsigned integer value is greater than the second unsigned integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMHI Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcgtq_u64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGT Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vcgt_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGT Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcgtq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGT Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcgtd_s64(Int64 a0, Int64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare unsigned Higher (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first unsigned integer value is greater than the second unsigned integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMHI Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcgtd_u64(UInt64 a0, UInt64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGT Sd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vcgts_f32(Single a0, Single a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGT Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcgtd_f64(Double a0, Double a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGT Vd.8B,Vn.8B,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vcgtz_s8(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGT Vd.16B,Vn.16B,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vcgtzq_s8(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGT Vd.4H,Vn.4H,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vcgtz_s16(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGT Vd.8H,Vn.8H,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vcgtzq_s16(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGT Vd.2S,Vn.2S,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vcgtz_s32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGT Vd.4S,Vn.4S,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vcgtzq_s32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGT Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vcgtz_s64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGT Vd.2D,Vn.2D,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vcgtzq_s64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGT Vd.2S,Vn.2S,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vcgtz_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGT Vd.4S,Vn.4S,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vcgtzq_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGT Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vcgtz_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGT Vd.2D,Vn.2D,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vcgtzq_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGT Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcgtzd_s64(Int64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGT Sd,Sn,#0</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vcgtzs_f32(Single a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGT Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcgtzd_f64(Double a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGT Dd,Dm,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vclt_s64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGT Vd.2D,Vm.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcltq_s64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare unsigned Higher (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first unsigned integer value is greater than the second unsigned integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMHI Dd,Dm,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vclt_u64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare unsigned Higher (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first unsigned integer value is greater than the second unsigned integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMHI Vd.2D,Vm.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcltq_u64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGT Dd,Dm,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vclt_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGT Vd.2D,Vm.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcltq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Greater than (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first signed integer value is greater than the second signed integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMGT Dd,Dm,Dn</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcltd_s64(Int64 a0, Int64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare unsigned Higher (vector). This instruction compares each vector element in the first source SIMD&amp;FP register with the corresponding vector element in the second source SIMD&amp;FP register and if the first unsigned integer value is greater than the second unsigned integer value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMHI Dd,Dm,Dn</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcltd_u64(UInt64 a0, UInt64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGT Sd,Sm,Sn</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vclts_f32(Single a0, Single a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Greater than (vector). This instruction reads each floating-point value in the first source SIMD&amp;FP register and if the value is greater than the corresponding floating-point value in the second source SIMD&amp;FP register sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMGT Dd,Dm,Dn</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcltd_f64(Double a0, Double a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Less than zero (vector). This instruction reads each vector element in the source SIMD&amp;FP register and if the signed integer value is less than zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMLT Vd.8B,Vn.8B,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vcltz_s8(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Less than zero (vector). This instruction reads each vector element in the source SIMD&amp;FP register and if the signed integer value is less than zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMLT Vd.16B,Vn.16B,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vcltzq_s8(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Less than zero (vector). This instruction reads each vector element in the source SIMD&amp;FP register and if the signed integer value is less than zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMLT Vd.4H,Vn.4H,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vcltz_s16(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Less than zero (vector). This instruction reads each vector element in the source SIMD&amp;FP register and if the signed integer value is less than zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMLT Vd.8H,Vn.8H,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vcltzq_s16(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Less than zero (vector). This instruction reads each vector element in the source SIMD&amp;FP register and if the signed integer value is less than zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMLT Vd.2S,Vn.2S,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vcltz_s32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Less than zero (vector). This instruction reads each vector element in the source SIMD&amp;FP register and if the signed integer value is less than zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMLT Vd.4S,Vn.4S,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vcltzq_s32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Less than zero (vector). This instruction reads each vector element in the source SIMD&amp;FP register and if the signed integer value is less than zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMLT Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vcltz_s64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Less than zero (vector). This instruction reads each vector element in the source SIMD&amp;FP register and if the signed integer value is less than zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMLT Vd.2D,Vn.2D,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vcltzq_s64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Less than zero (vector). This instruction reads each floating-point value in the source SIMD&amp;FP register and if the value is less than zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMLT Vd.2S,Vn.2S,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vcltz_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Less than zero (vector). This instruction reads each floating-point value in the source SIMD&amp;FP register and if the value is less than zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMLT Vd.4S,Vn.4S,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vcltzq_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Less than zero (vector). This instruction reads each floating-point value in the source SIMD&amp;FP register and if the value is less than zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMLT Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static v64 vcltz_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Less than zero (vector). This instruction reads each floating-point value in the source SIMD&amp;FP register and if the value is less than zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMLT Vd.2D,Vn.2D,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vcltzq_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare signed Less than zero (vector). This instruction reads each vector element in the source SIMD&amp;FP register and if the signed integer value is less than zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMLT Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcltzd_s64(Int64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Less than zero (vector). This instruction reads each floating-point value in the source SIMD&amp;FP register and if the value is less than zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMLT Sd,Sn,#0</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vcltzs_f32(Single a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Compare Less than zero (vector). This instruction reads each floating-point value in the source SIMD&amp;FP register and if the value is less than zero sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCMLT Dd,Dn,#0</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcltzd_f64(Double a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Compare Greater than or Equal (vector). This instruction compares the absolute value of each floating-point value in the first source SIMD&amp;FP register with the absolute value of the corresponding floating-point value in the second source SIMD&amp;FP register and if the first value is greater than or equal to the second value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FACGE Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vcage_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Compare Greater than or Equal (vector). This instruction compares the absolute value of each floating-point value in the first source SIMD&amp;FP register with the absolute value of the corresponding floating-point value in the second source SIMD&amp;FP register and if the first value is greater than or equal to the second value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FACGE Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcageq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Compare Greater than or Equal (vector). This instruction compares the absolute value of each floating-point value in the first source SIMD&amp;FP register with the absolute value of the corresponding floating-point value in the second source SIMD&amp;FP register and if the first value is greater than or equal to the second value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FACGE Sd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vcages_f32(Single a0, Single a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Compare Greater than or Equal (vector). This instruction compares the absolute value of each floating-point value in the first source SIMD&amp;FP register with the absolute value of the corresponding floating-point value in the second source SIMD&amp;FP register and if the first value is greater than or equal to the second value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FACGE Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcaged_f64(Double a0, Double a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Compare Greater than or Equal (vector). This instruction compares the absolute value of each floating-point value in the first source SIMD&amp;FP register with the absolute value of the corresponding floating-point value in the second source SIMD&amp;FP register and if the first value is greater than or equal to the second value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FACGE Dd,Dm,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vcale_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Compare Greater than or Equal (vector). This instruction compares the absolute value of each floating-point value in the first source SIMD&amp;FP register with the absolute value of the corresponding floating-point value in the second source SIMD&amp;FP register and if the first value is greater than or equal to the second value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FACGE Vd.2D,Vm.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcaleq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Compare Greater than or Equal (vector). This instruction compares the absolute value of each floating-point value in the first source SIMD&amp;FP register with the absolute value of the corresponding floating-point value in the second source SIMD&amp;FP register and if the first value is greater than or equal to the second value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FACGE Sd,Sm,Sn</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vcales_f32(Single a0, Single a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Compare Greater than or Equal (vector). This instruction compares the absolute value of each floating-point value in the first source SIMD&amp;FP register with the absolute value of the corresponding floating-point value in the second source SIMD&amp;FP register and if the first value is greater than or equal to the second value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FACGE Dd,Dm,Dn</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcaled_f64(Double a0, Double a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Compare Greater than (vector). This instruction compares the absolute value of each vector element in the first source SIMD&amp;FP register with the absolute value of the corresponding vector element in the second source SIMD&amp;FP register and if the first value is greater than the second value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FACGT Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vcagt_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Compare Greater than (vector). This instruction compares the absolute value of each vector element in the first source SIMD&amp;FP register with the absolute value of the corresponding vector element in the second source SIMD&amp;FP register and if the first value is greater than the second value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FACGT Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcagtq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Compare Greater than (vector). This instruction compares the absolute value of each vector element in the first source SIMD&amp;FP register with the absolute value of the corresponding vector element in the second source SIMD&amp;FP register and if the first value is greater than the second value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FACGT Sd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vcagts_f32(Single a0, Single a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Compare Greater than (vector). This instruction compares the absolute value of each vector element in the first source SIMD&amp;FP register with the absolute value of the corresponding vector element in the second source SIMD&amp;FP register and if the first value is greater than the second value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FACGT Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcagtd_f64(Double a0, Double a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Compare Greater than (vector). This instruction compares the absolute value of each vector element in the first source SIMD&amp;FP register with the absolute value of the corresponding vector element in the second source SIMD&amp;FP register and if the first value is greater than the second value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FACGT Dd,Dm,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vcalt_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Compare Greater than (vector). This instruction compares the absolute value of each vector element in the first source SIMD&amp;FP register with the absolute value of the corresponding vector element in the second source SIMD&amp;FP register and if the first value is greater than the second value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FACGT Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcaltq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Compare Greater than (vector). This instruction compares the absolute value of each vector element in the first source SIMD&amp;FP register with the absolute value of the corresponding vector element in the second source SIMD&amp;FP register and if the first value is greater than the second value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FACGT Sd,Sm,Sn</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vcalts_f32(Single a0, Single a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Compare Greater than (vector). This instruction compares the absolute value of each vector element in the first source SIMD&amp;FP register with the absolute value of the corresponding vector element in the second source SIMD&amp;FP register and if the first value is greater than the second value sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FACGT Dd,Dm,Dn</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcaltd_f64(Double a0, Double a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Test bits nonzero (vector). This instruction reads each vector element in the first source SIMD&amp;FP register, performs an AND with the corresponding vector element in the second source SIMD&amp;FP register, and if the result is not zero, sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMTST Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vtst_s64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Test bits nonzero (vector). This instruction reads each vector element in the first source SIMD&amp;FP register, performs an AND with the corresponding vector element in the second source SIMD&amp;FP register, and if the result is not zero, sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMTST Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vtstq_s64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Test bits nonzero (vector). This instruction reads each vector element in the first source SIMD&amp;FP register, performs an AND with the corresponding vector element in the second source SIMD&amp;FP register, and if the result is not zero, sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMTST Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vtst_u64(v64 a0, v64 a1)
            {
                return vtst_s64(a0, a1);
            }

            /// <summary>Compare bitwise Test bits nonzero (vector). This instruction reads each vector element in the first source SIMD&amp;FP register, performs an AND with the corresponding vector element in the second source SIMD&amp;FP register, and if the result is not zero, sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMTST Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vtstq_u64(v128 a0, v128 a1)
            {
                return vtstq_s64(a0, a1);
            }

            /// <summary>Compare bitwise Test bits nonzero (vector). This instruction reads each vector element in the first source SIMD&amp;FP register, performs an AND with the corresponding vector element in the second source SIMD&amp;FP register, and if the result is not zero, sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMTST Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vtstd_s64(Int64 a0, Int64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Compare bitwise Test bits nonzero (vector). This instruction reads each vector element in the first source SIMD&amp;FP register, performs an AND with the corresponding vector element in the second source SIMD&amp;FP register, and if the result is not zero, sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to one, otherwise sets every bit of the corresponding vector element in the destination SIMD&amp;FP register to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>CMTST Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vtstd_u64(UInt64 a0, UInt64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Difference (vector). This instruction subtracts the floating-point values in the elements of the second source SIMD&amp;FP register, from the corresponding floating-point values in the elements of the first source SIMD&amp;FP register, places the absolute value of each result in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FABD Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vabd_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Difference (vector). This instruction subtracts the floating-point values in the elements of the second source SIMD&amp;FP register, from the corresponding floating-point values in the elements of the first source SIMD&amp;FP register, places the absolute value of each result in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FABD Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vabdq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Difference (vector). This instruction subtracts the floating-point values in the elements of the second source SIMD&amp;FP register, from the corresponding floating-point values in the elements of the first source SIMD&amp;FP register, places the absolute value of each result in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FABD Sd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static Single vabds_f32(Single a0, Single a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute Difference (vector). This instruction subtracts the floating-point values in the elements of the second source SIMD&amp;FP register, from the corresponding floating-point values in the elements of the first source SIMD&amp;FP register, places the absolute value of each result in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FABD Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static Double vabdd_f64(Double a0, Double a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Absolute Difference Long. This instruction subtracts the vector elements of the second source SIMD&amp;FP register from the corresponding vector elements of the first source SIMD&amp;FP register, places the absolute value of the results into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements.The SABDL instruction writes the vector to the lower half of the destination register and clears the upper half, while the SABDL2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SABDL2 Vd.8H,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vabdl_high_s8(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Absolute Difference Long. This instruction subtracts the vector elements of the second source SIMD&amp;FP register from the corresponding vector elements of the first source SIMD&amp;FP register, places the absolute value of the results into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements.The SABDL instruction writes the vector to the lower half of the destination register and clears the upper half, while the SABDL2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SABDL2 Vd.4S,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vabdl_high_s16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Absolute Difference Long. This instruction subtracts the vector elements of the second source SIMD&amp;FP register from the corresponding vector elements of the first source SIMD&amp;FP register, places the absolute value of the results into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements.The SABDL instruction writes the vector to the lower half of the destination register and clears the upper half, while the SABDL2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SABDL2 Vd.2D,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vabdl_high_s32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Absolute Difference Long. This instruction subtracts the vector elements in the lower or upper half of the second source SIMD&amp;FP register from the corresponding vector elements of the first source SIMD&amp;FP register, places the absolute value of the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements. All the values in this instruction are unsigned integer values.The UABDL instruction extracts each source vector from the lower half of each source register, while the UABDL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UABDL2 Vd.8H,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vabdl_high_u8(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Absolute Difference Long. This instruction subtracts the vector elements in the lower or upper half of the second source SIMD&amp;FP register from the corresponding vector elements of the first source SIMD&amp;FP register, places the absolute value of the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements. All the values in this instruction are unsigned integer values.The UABDL instruction extracts each source vector from the lower half of each source register, while the UABDL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UABDL2 Vd.4S,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vabdl_high_u16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Absolute Difference Long. This instruction subtracts the vector elements in the lower or upper half of the second source SIMD&amp;FP register from the corresponding vector elements of the first source SIMD&amp;FP register, places the absolute value of the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements. All the values in this instruction are unsigned integer values.The UABDL instruction extracts each source vector from the lower half of each source register, while the UABDL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UABDL2 Vd.2D,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vabdl_high_u32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Absolute difference and Accumulate Long. This instruction subtracts the vector elements in the lower or upper half of the second source SIMD&amp;FP register from the corresponding vector elements of the first source SIMD&amp;FP register, and accumulates the absolute values of the results into the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements.The SABAL instruction extracts each source vector from the lower half of each source register, while the SABAL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SABAL2 Vd.8H,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vabal_high_s8(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Absolute difference and Accumulate Long. This instruction subtracts the vector elements in the lower or upper half of the second source SIMD&amp;FP register from the corresponding vector elements of the first source SIMD&amp;FP register, and accumulates the absolute values of the results into the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements.The SABAL instruction extracts each source vector from the lower half of each source register, while the SABAL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SABAL2 Vd.4S,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vabal_high_s16(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Absolute difference and Accumulate Long. This instruction subtracts the vector elements in the lower or upper half of the second source SIMD&amp;FP register from the corresponding vector elements of the first source SIMD&amp;FP register, and accumulates the absolute values of the results into the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements.The SABAL instruction extracts each source vector from the lower half of each source register, while the SABAL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SABAL2 Vd.2D,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vabal_high_s32(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Absolute difference and Accumulate Long. This instruction subtracts the vector elements in the lower or upper half of the second source SIMD&amp;FP register from the corresponding vector elements of the first source SIMD&amp;FP register, and accumulates the absolute values of the results into the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements. All the values in this instruction are unsigned integer values.The UABAL instruction extracts each source vector from the lower half of each source register, while the UABAL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UABAL2 Vd.8H,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vabal_high_u8(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Absolute difference and Accumulate Long. This instruction subtracts the vector elements in the lower or upper half of the second source SIMD&amp;FP register from the corresponding vector elements of the first source SIMD&amp;FP register, and accumulates the absolute values of the results into the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements. All the values in this instruction are unsigned integer values.The UABAL instruction extracts each source vector from the lower half of each source register, while the UABAL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UABAL2 Vd.4S,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vabal_high_u16(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Absolute difference and Accumulate Long. This instruction subtracts the vector elements in the lower or upper half of the second source SIMD&amp;FP register from the corresponding vector elements of the first source SIMD&amp;FP register, and accumulates the absolute values of the results into the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements. All the values in this instruction are unsigned integer values.The UABAL instruction extracts each source vector from the lower half of each source register, while the UABAL2 instruction extracts each source vector from the upper half of each source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UABAL2 Vd.2D,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vabal_high_u32(v128 a0, v128 a1, v128 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Maximum (vector). This instruction compares corresponding vector elements in the two source SIMD&amp;FP registers, places the larger of each of the two floating-point values into a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMAX Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vmax_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Maximum (vector). This instruction compares corresponding vector elements in the two source SIMD&amp;FP registers, places the larger of each of the two floating-point values into a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMAX Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vmaxq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point minimum (vector). This instruction compares corresponding elements in the vectors in the two source SIMD&amp;FP registers, places the smaller of each of the two floating-point values into a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMIN Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vmin_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point minimum (vector). This instruction compares corresponding elements in the vectors in the two source SIMD&amp;FP registers, places the smaller of each of the two floating-point values into a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMIN Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vminq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Maximum Number (vector). This instruction compares corresponding vector elements in the two source SIMD&amp;FP registers, writes the larger of the two floating-point values into a vector, and writes the vector to the destination SIMD&amp;FP register.NaNs are handled according to the IEEE 754-2008 standard. If one vector element is numeric and the other is a quiet NaN, the result placed in the vector is the numerical value, otherwise the result is identical to FMAX (scalar).This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMAXNM Vd.2S,Vn.2S,Vm.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vmaxnm_f32(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Maximum Number (vector). This instruction compares corresponding vector elements in the two source SIMD&amp;FP registers, writes the larger of the two floating-point values into a vector, and writes the vector to the destination SIMD&amp;FP register.NaNs are handled according to the IEEE 754-2008 standard. If one vector element is numeric and the other is a quiet NaN, the result placed in the vector is the numerical value, otherwise the result is identical to FMAX (scalar).This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMAXNM Vd.4S,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vmaxnmq_f32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Maximum Number (vector). This instruction compares corresponding vector elements in the two source SIMD&amp;FP registers, writes the larger of the two floating-point values into a vector, and writes the vector to the destination SIMD&amp;FP register.NaNs are handled according to the IEEE 754-2008 standard. If one vector element is numeric and the other is a quiet NaN, the result placed in the vector is the numerical value, otherwise the result is identical to FMAX (scalar).This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMAXNM Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vmaxnm_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Maximum Number (vector). This instruction compares corresponding vector elements in the two source SIMD&amp;FP registers, writes the larger of the two floating-point values into a vector, and writes the vector to the destination SIMD&amp;FP register.NaNs are handled according to the IEEE 754-2008 standard. If one vector element is numeric and the other is a quiet NaN, the result placed in the vector is the numerical value, otherwise the result is identical to FMAX (scalar).This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMAXNM Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vmaxnmq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Minimum Number (vector). This instruction compares corresponding vector elements in the two source SIMD&amp;FP registers, writes the smaller of the two floating-point values into a vector, and writes the vector to the destination SIMD&amp;FP register.NaNs are handled according to the IEEE 754-2008 standard. If one vector element is numeric and the other is a quiet NaN, the result placed in the vector is the numerical value, otherwise the result is identical to FMIN (scalar).This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMINNM Vd.2S,Vn.2S,Vm.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vminnm_f32(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Minimum Number (vector). This instruction compares corresponding vector elements in the two source SIMD&amp;FP registers, writes the smaller of the two floating-point values into a vector, and writes the vector to the destination SIMD&amp;FP register.NaNs are handled according to the IEEE 754-2008 standard. If one vector element is numeric and the other is a quiet NaN, the result placed in the vector is the numerical value, otherwise the result is identical to FMIN (scalar).This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMINNM Vd.4S,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vminnmq_f32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Minimum Number (vector). This instruction compares corresponding vector elements in the two source SIMD&amp;FP registers, writes the smaller of the two floating-point values into a vector, and writes the vector to the destination SIMD&amp;FP register.NaNs are handled according to the IEEE 754-2008 standard. If one vector element is numeric and the other is a quiet NaN, the result placed in the vector is the numerical value, otherwise the result is identical to FMIN (scalar).This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMINNM Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vminnm_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Minimum Number (vector). This instruction compares corresponding vector elements in the two source SIMD&amp;FP registers, writes the smaller of the two floating-point values into a vector, and writes the vector to the destination SIMD&amp;FP register.NaNs are handled according to the IEEE 754-2008 standard. If one vector element is numeric and the other is a quiet NaN, the result placed in the vector is the numerical value, otherwise the result is identical to FMIN (scalar).This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMINNM Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vminnmq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Shift Left (register). This instruction takes each signed integer value in the vector of the first source SIMD&amp;FP register, shifts each value by a value from the least significant byte of the corresponding element of the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If the shift value is positive, the operation is a left shift. If the shift value is negative, it is a truncating right shift. For a rounding shift, see SRSHL.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SSHL Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static Int64 vshld_s64(Int64 a0, Int64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Shift Left (register). This instruction takes each element in the vector of the first source SIMD&amp;FP register, shifts each element by a value from the least significant byte of the corresponding element of the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If the shift value is positive, the operation is a left shift. If the shift value is negative, it is a truncating right shift. For a rounding shift, see URSHL.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USHL Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vshld_u64(UInt64 a0, Int64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Left (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, shifts each result by an immediate value, places the final result in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHL Bd,Bn,Bm</c></summary>
            [DebuggerStepThrough]
            public static SByte vqshlb_s8(SByte a0, SByte a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Left (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, shifts each result by an immediate value, places the final result in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHL Hd,Hn,Hm</c></summary>
            [DebuggerStepThrough]
            public static Int16 vqshlh_s16(Int16 a0, Int16 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Left (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, shifts each result by an immediate value, places the final result in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHL Sd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqshls_s32(Int32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Left (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, shifts each result by an immediate value, places the final result in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHL Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static Int64 vqshld_s64(Int64 a0, Int64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Shift Left (immediate). This instruction takes each vector element in the source SIMD&amp;FP register, shifts it by an immediate value, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQSHL Bd,Bn,Bm</c></summary>
            [DebuggerStepThrough]
            public static Byte vqshlb_u8(Byte a0, SByte a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Shift Left (immediate). This instruction takes each vector element in the source SIMD&amp;FP register, shifts it by an immediate value, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQSHL Hd,Hn,Hm</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vqshlh_u16(UInt16 a0, Int16 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Shift Left (immediate). This instruction takes each vector element in the source SIMD&amp;FP register, shifts it by an immediate value, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQSHL Sd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vqshls_u32(UInt32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Shift Left (immediate). This instruction takes each vector element in the source SIMD&amp;FP register, shifts it by an immediate value, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQSHL Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vqshld_u64(UInt64 a0, Int64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Rounding Shift Left (register). This instruction takes each signed integer value in the vector of the first source SIMD&amp;FP register, shifts it by a value from the least significant byte of the corresponding element of the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If the shift value is positive, the operation is a left shift. If the shift value is negative, it is a rounding right shift. For a truncating shift, see SSHL.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SRSHL Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static Int64 vrshld_s64(Int64 a0, Int64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Rounding Shift Left (register). This instruction takes each element in the vector of the first source SIMD&amp;FP register, shifts the vector element by a value from the least significant byte of the corresponding element of the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register.If the shift value is positive, the operation is a left shift. If the shift value is negative, it is a rounding right shift.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>URSHL Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vrshld_u64(UInt64 a0, Int64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounding Shift Left (register). This instruction takes each vector element in the first source SIMD&amp;FP register, shifts it by a value from the least significant byte of the corresponding vector element of the second source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If the shift value is positive, the operation is a left shift. Otherwise, it is a right shift. The results are rounded. For truncated results, see SQSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRSHL Bd,Bn,Bm</c></summary>
            [DebuggerStepThrough]
            public static SByte vqrshlb_s8(SByte a0, SByte a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounding Shift Left (register). This instruction takes each vector element in the first source SIMD&amp;FP register, shifts it by a value from the least significant byte of the corresponding vector element of the second source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If the shift value is positive, the operation is a left shift. Otherwise, it is a right shift. The results are rounded. For truncated results, see SQSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRSHL Hd,Hn,Hm</c></summary>
            [DebuggerStepThrough]
            public static Int16 vqrshlh_s16(Int16 a0, Int16 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounding Shift Left (register). This instruction takes each vector element in the first source SIMD&amp;FP register, shifts it by a value from the least significant byte of the corresponding vector element of the second source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If the shift value is positive, the operation is a left shift. Otherwise, it is a right shift. The results are rounded. For truncated results, see SQSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRSHL Sd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqrshls_s32(Int32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounding Shift Left (register). This instruction takes each vector element in the first source SIMD&amp;FP register, shifts it by a value from the least significant byte of the corresponding vector element of the second source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If the shift value is positive, the operation is a left shift. Otherwise, it is a right shift. The results are rounded. For truncated results, see SQSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRSHL Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static Int64 vqrshld_s64(Int64 a0, Int64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Rounding Shift Left (register). This instruction takes each vector element of the first source SIMD&amp;FP register, shifts the vector element by a value from the least significant byte of the corresponding vector element of the second source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If the shift value is positive, the operation is a left shift. Otherwise, it is a right shift. The results are rounded. For truncated results, see UQSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQRSHL Bd,Bn,Bm</c></summary>
            [DebuggerStepThrough]
            public static Byte vqrshlb_u8(Byte a0, SByte a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Rounding Shift Left (register). This instruction takes each vector element of the first source SIMD&amp;FP register, shifts the vector element by a value from the least significant byte of the corresponding vector element of the second source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If the shift value is positive, the operation is a left shift. Otherwise, it is a right shift. The results are rounded. For truncated results, see UQSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQRSHL Hd,Hn,Hm</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vqrshlh_u16(UInt16 a0, Int16 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Rounding Shift Left (register). This instruction takes each vector element of the first source SIMD&amp;FP register, shifts the vector element by a value from the least significant byte of the corresponding vector element of the second source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If the shift value is positive, the operation is a left shift. Otherwise, it is a right shift. The results are rounded. For truncated results, see UQSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQRSHL Sd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vqrshls_u32(UInt32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Rounding Shift Left (register). This instruction takes each vector element of the first source SIMD&amp;FP register, shifts the vector element by a value from the least significant byte of the corresponding vector element of the second source SIMD&amp;FP register, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.If the shift value is positive, the operation is a left shift. Otherwise, it is a right shift. The results are rounded. For truncated results, see UQSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQRSHL Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vqrshld_u64(UInt64 a0, Int64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Shift Right (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, places the final result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values. The results are truncated. For rounded results, see SRSHR.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SSHR Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static Int64 vshrd_n_s64(Int64 a0, Int32 a1)
            {
                return a0 >> a1;
            }

            /// <summary>Unsigned Shift Right (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, writes the final result to a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values. The results are truncated. For rounded results, see URSHR.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USHR Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vshrd_n_u64(UInt64 a0, Int32 a1)
            {
                return a0 >> a1;
            }

            /// <summary>Shift Left (immediate). This instruction reads each value from a vector, left shifts each result by an immediate value, writes the final result to a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SHL Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static Int64 vshld_n_s64(Int64 a0, Int32 a1)
            {
                return a0 << a1;
            }

            /// <summary>Shift Left (immediate). This instruction reads each value from a vector, left shifts each result by an immediate value, writes the final result to a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SHL Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vshld_n_u64(UInt64 a0, Int32 a1)
            {
                return a0 << a1;
            }

            /// <summary>Signed Rounding Shift Right (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, places the final result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values. The results are rounded. For truncated results, see SSHR.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SRSHR Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static Int64 vrshrd_n_s64(Int64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Rounding Shift Right (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, writes the final result to a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values. The results are rounded. For truncated results, see USHR.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>URSHR Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vrshrd_n_u64(UInt64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Shift Right and Accumulate (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are signed integer values. The results are truncated. For rounded results, see SRSRA.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SSRA Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static Int64 vsrad_n_s64(Int64 a0, Int64 a1, Int32 a2)
            {
                return a0 + (a1 >> a2);
            }

            /// <summary>Unsigned Shift Right and Accumulate (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values. The results are truncated. For rounded results, see URSRA.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USRA Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vsrad_n_u64(UInt64 a0, UInt64 a1, Int32 a2)
            {
                return a0 + (a1 >> a2);
            }

            /// <summary>Signed Rounding Shift Right and Accumulate (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are signed integer values. The results are rounded. For truncated results, see SSRA.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SRSRA Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static Int64 vrsrad_n_s64(Int64 a0, Int64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Rounding Shift Right and Accumulate (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values. The results are rounded. For truncated results, see USRA.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>URSRA Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vrsrad_n_u64(UInt64 a0, UInt64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Left (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, shifts each result by an immediate value, places the final result in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHL Bd,Bn,#n</c></summary>
            [DebuggerStepThrough]
            public static SByte vqshlb_n_s8(SByte a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Left (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, shifts each result by an immediate value, places the final result in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHL Hd,Hn,#n</c></summary>
            [DebuggerStepThrough]
            public static Int16 vqshlh_n_s16(Int16 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Left (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, shifts each result by an immediate value, places the final result in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHL Sd,Sn,#n</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqshls_n_s32(Int32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Left (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, shifts each result by an immediate value, places the final result in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHL Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static Int64 vqshld_n_s64(Int64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Shift Left (immediate). This instruction takes each vector element in the source SIMD&amp;FP register, shifts it by an immediate value, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQSHL Bd,Bn,#n</c></summary>
            [DebuggerStepThrough]
            public static Byte vqshlb_n_u8(Byte a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Shift Left (immediate). This instruction takes each vector element in the source SIMD&amp;FP register, shifts it by an immediate value, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQSHL Hd,Hn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vqshlh_n_u16(UInt16 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Shift Left (immediate). This instruction takes each vector element in the source SIMD&amp;FP register, shifts it by an immediate value, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQSHL Sd,Sn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vqshls_n_u32(UInt32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Shift Left (immediate). This instruction takes each vector element in the source SIMD&amp;FP register, shifts it by an immediate value, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQSHL Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vqshld_n_u64(UInt64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Left Unsigned (immediate). This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, shifts each value by an immediate value, saturates the shifted result to an unsigned integer value, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHLU Bd,Bn,#n</c></summary>
            [DebuggerStepThrough]
            public static Byte vqshlub_n_s8(SByte a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Left Unsigned (immediate). This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, shifts each value by an immediate value, saturates the shifted result to an unsigned integer value, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHLU Hd,Hn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vqshluh_n_s16(Int16 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Left Unsigned (immediate). This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, shifts each value by an immediate value, saturates the shifted result to an unsigned integer value, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHLU Sd,Sn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vqshlus_n_s32(Int32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Left Unsigned (immediate). This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, shifts each value by an immediate value, saturates the shifted result to an unsigned integer value, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see UQRSHL.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHLU Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vqshlud_n_s64(Int64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Shift Right Narrow (immediate). This instruction reads each unsigned integer value from the vector in the source SIMD&amp;FP register, right shifts each result by an immediate value, writes the final result to a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. The results are rounded. For truncated results, see SHRN.The RSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SHRN2 Vd.16B,Vn.8H,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vshrn_high_n_s16(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Shift Right Narrow (immediate). This instruction reads each unsigned integer value from the vector in the source SIMD&amp;FP register, right shifts each result by an immediate value, writes the final result to a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. The results are rounded. For truncated results, see SHRN.The RSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SHRN2 Vd.8H,Vn.4S,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vshrn_high_n_s32(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Shift Right Narrow (immediate). This instruction reads each unsigned integer value from the vector in the source SIMD&amp;FP register, right shifts each result by an immediate value, writes the final result to a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. The results are rounded. For truncated results, see SHRN.The RSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SHRN2 Vd.4S,Vn.2D,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vshrn_high_n_s64(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Shift Right Narrow (immediate). This instruction reads each unsigned integer value from the vector in the source SIMD&amp;FP register, right shifts each result by an immediate value, writes the final result to a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. The results are rounded. For truncated results, see SHRN.The RSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SHRN2 Vd.16B,Vn.8H,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vshrn_high_n_u16(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Shift Right Narrow (immediate). This instruction reads each unsigned integer value from the vector in the source SIMD&amp;FP register, right shifts each result by an immediate value, writes the final result to a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. The results are rounded. For truncated results, see SHRN.The RSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SHRN2 Vd.8H,Vn.4S,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vshrn_high_n_u32(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Shift Right Narrow (immediate). This instruction reads each unsigned integer value from the vector in the source SIMD&amp;FP register, right shifts each result by an immediate value, writes the final result to a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. The results are rounded. For truncated results, see SHRN.The RSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SHRN2 Vd.4S,Vn.2D,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vshrn_high_n_u64(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Right Unsigned Narrow (immediate). This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, right shifts each value by an immediate value, saturates the result to an unsigned integer value that is half the original width, places the final result into a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see SQRSHRUN.The SQSHRUN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQSHRUN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHRUN Bd,Hn,#n</c></summary>
            [DebuggerStepThrough]
            public static Byte vqshrunh_n_s16(Int16 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Right Unsigned Narrow (immediate). This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, right shifts each value by an immediate value, saturates the result to an unsigned integer value that is half the original width, places the final result into a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see SQRSHRUN.The SQSHRUN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQSHRUN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHRUN Hd,Sn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vqshruns_n_s32(Int32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Right Unsigned Narrow (immediate). This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, right shifts each value by an immediate value, saturates the result to an unsigned integer value that is half the original width, places the final result into a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see SQRSHRUN.The SQSHRUN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQSHRUN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHRUN Sd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vqshrund_n_s64(Int64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Right Unsigned Narrow (immediate). This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, right shifts each value by an immediate value, saturates the result to an unsigned integer value that is half the original width, places the final result into a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see SQRSHRUN.The SQSHRUN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQSHRUN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHRUN2 Vd.16B,Vn.8H,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vqshrun_high_n_s16(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Right Unsigned Narrow (immediate). This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, right shifts each value by an immediate value, saturates the result to an unsigned integer value that is half the original width, places the final result into a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see SQRSHRUN.The SQSHRUN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQSHRUN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHRUN2 Vd.8H,Vn.4S,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vqshrun_high_n_s32(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Right Unsigned Narrow (immediate). This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, right shifts each value by an immediate value, saturates the result to an unsigned integer value that is half the original width, places the final result into a vector, and writes the vector to the destination SIMD&amp;FP register. The results are truncated. For rounded results, see SQRSHRUN.The SQSHRUN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQSHRUN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHRUN2 Vd.4S,Vn.2D,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vqshrun_high_n_s64(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounded Shift Right Unsigned Narrow (immediate). This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, right shifts each value by an immediate value, saturates the result to an unsigned integer value that is half the original width, places the final result into a vector, and writes the vector to the destination SIMD&amp;FP register. The results are rounded. For truncated results, see SQSHRUN.The SQRSHRUN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQRSHRUN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRSHRUN Bd,Hn,#n</c></summary>
            [DebuggerStepThrough]
            public static Byte vqrshrunh_n_s16(Int16 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounded Shift Right Unsigned Narrow (immediate). This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, right shifts each value by an immediate value, saturates the result to an unsigned integer value that is half the original width, places the final result into a vector, and writes the vector to the destination SIMD&amp;FP register. The results are rounded. For truncated results, see SQSHRUN.The SQRSHRUN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQRSHRUN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRSHRUN Hd,Sn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vqrshruns_n_s32(Int32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounded Shift Right Unsigned Narrow (immediate). This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, right shifts each value by an immediate value, saturates the result to an unsigned integer value that is half the original width, places the final result into a vector, and writes the vector to the destination SIMD&amp;FP register. The results are rounded. For truncated results, see SQSHRUN.The SQRSHRUN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQRSHRUN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRSHRUN Sd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vqrshrund_n_s64(Int64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounded Shift Right Unsigned Narrow (immediate). This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, right shifts each value by an immediate value, saturates the result to an unsigned integer value that is half the original width, places the final result into a vector, and writes the vector to the destination SIMD&amp;FP register. The results are rounded. For truncated results, see SQSHRUN.The SQRSHRUN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQRSHRUN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRSHRUN2 Vd.16B,Vn.8H,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vqrshrun_high_n_s16(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounded Shift Right Unsigned Narrow (immediate). This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, right shifts each value by an immediate value, saturates the result to an unsigned integer value that is half the original width, places the final result into a vector, and writes the vector to the destination SIMD&amp;FP register. The results are rounded. For truncated results, see SQSHRUN.The SQRSHRUN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQRSHRUN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRSHRUN2 Vd.8H,Vn.4S,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vqrshrun_high_n_s32(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounded Shift Right Unsigned Narrow (immediate). This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, right shifts each value by an immediate value, saturates the result to an unsigned integer value that is half the original width, places the final result into a vector, and writes the vector to the destination SIMD&amp;FP register. The results are rounded. For truncated results, see SQSHRUN.The SQRSHRUN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQRSHRUN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRSHRUN2 Vd.4S,Vn.2D,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vqrshrun_high_n_s64(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts and truncates each result by an immediate value, saturates each shifted result to a value that is half the original width, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are signed integer values. The destination vector elements are half as long as the source vector elements. For rounded results, see SQRSHRN.The SQSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHRN Bd,Hn,#n</c></summary>
            [DebuggerStepThrough]
            public static SByte vqshrnh_n_s16(Int16 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts and truncates each result by an immediate value, saturates each shifted result to a value that is half the original width, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are signed integer values. The destination vector elements are half as long as the source vector elements. For rounded results, see SQRSHRN.The SQSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHRN Hd,Sn,#n</c></summary>
            [DebuggerStepThrough]
            public static Int16 vqshrns_n_s32(Int32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts and truncates each result by an immediate value, saturates each shifted result to a value that is half the original width, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are signed integer values. The destination vector elements are half as long as the source vector elements. For rounded results, see SQRSHRN.The SQSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHRN Sd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqshrnd_n_s64(Int64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, saturates each shifted result to a value that is half the original width, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values. The results are truncated. For rounded results, see UQRSHRN.The UQSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the UQSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQSHRN Bd,Hn,#n</c></summary>
            [DebuggerStepThrough]
            public static Byte vqshrnh_n_u16(UInt16 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, saturates each shifted result to a value that is half the original width, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values. The results are truncated. For rounded results, see UQRSHRN.The UQSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the UQSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQSHRN Hd,Sn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vqshrns_n_u32(UInt32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, saturates each shifted result to a value that is half the original width, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values. The results are truncated. For rounded results, see UQRSHRN.The UQSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the UQSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQSHRN Sd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vqshrnd_n_u64(UInt64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts and truncates each result by an immediate value, saturates each shifted result to a value that is half the original width, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are signed integer values. The destination vector elements are half as long as the source vector elements. For rounded results, see SQRSHRN.The SQSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHRN2 Vd.16B,Vn.8H,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vqshrn_high_n_s16(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts and truncates each result by an immediate value, saturates each shifted result to a value that is half the original width, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are signed integer values. The destination vector elements are half as long as the source vector elements. For rounded results, see SQRSHRN.The SQSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHRN2 Vd.8H,Vn.4S,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vqshrn_high_n_s32(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts and truncates each result by an immediate value, saturates each shifted result to a value that is half the original width, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are signed integer values. The destination vector elements are half as long as the source vector elements. For rounded results, see SQRSHRN.The SQSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQSHRN2 Vd.4S,Vn.2D,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vqshrn_high_n_s64(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, saturates each shifted result to a value that is half the original width, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values. The results are truncated. For rounded results, see UQRSHRN.The UQSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the UQSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQSHRN2 Vd.16B,Vn.8H,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vqshrn_high_n_u16(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, saturates each shifted result to a value that is half the original width, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values. The results are truncated. For rounded results, see UQRSHRN.The UQSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the UQSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQSHRN2 Vd.8H,Vn.4S,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vqshrn_high_n_u32(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, saturates each shifted result to a value that is half the original width, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values. The results are truncated. For rounded results, see UQRSHRN.The UQSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the UQSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQSHRN2 Vd.4S,Vn.2D,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vqshrn_high_n_u64(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Shift Right Narrow (immediate). This instruction reads each unsigned integer value from the vector in the source SIMD&amp;FP register, right shifts each result by an immediate value, writes the final result to a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. The results are rounded. For truncated results, see SHRN.The RSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RSHRN2 Vd.16B,Vn.8H,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vrshrn_high_n_s16(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Shift Right Narrow (immediate). This instruction reads each unsigned integer value from the vector in the source SIMD&amp;FP register, right shifts each result by an immediate value, writes the final result to a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. The results are rounded. For truncated results, see SHRN.The RSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RSHRN2 Vd.8H,Vn.4S,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vrshrn_high_n_s32(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Shift Right Narrow (immediate). This instruction reads each unsigned integer value from the vector in the source SIMD&amp;FP register, right shifts each result by an immediate value, writes the final result to a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. The results are rounded. For truncated results, see SHRN.The RSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RSHRN2 Vd.4S,Vn.2D,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vrshrn_high_n_s64(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Shift Right Narrow (immediate). This instruction reads each unsigned integer value from the vector in the source SIMD&amp;FP register, right shifts each result by an immediate value, writes the final result to a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. The results are rounded. For truncated results, see SHRN.The RSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RSHRN2 Vd.16B,Vn.8H,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vrshrn_high_n_u16(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Shift Right Narrow (immediate). This instruction reads each unsigned integer value from the vector in the source SIMD&amp;FP register, right shifts each result by an immediate value, writes the final result to a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. The results are rounded. For truncated results, see SHRN.The RSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RSHRN2 Vd.8H,Vn.4S,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vrshrn_high_n_u32(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Rounding Shift Right Narrow (immediate). This instruction reads each unsigned integer value from the vector in the source SIMD&amp;FP register, right shifts each result by an immediate value, writes the final result to a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. The results are rounded. For truncated results, see SHRN.The RSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the RSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RSHRN2 Vd.4S,Vn.2D,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vrshrn_high_n_u64(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounded Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, saturates each shifted result to a value that is half the original width, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are signed integer values. The destination vector elements are half as long as the source vector elements. The results are rounded. For truncated results, see SQSHRN.The SQRSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQRSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRSHRN Bd,Hn,#n</c></summary>
            [DebuggerStepThrough]
            public static SByte vqrshrnh_n_s16(Int16 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounded Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, saturates each shifted result to a value that is half the original width, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are signed integer values. The destination vector elements are half as long as the source vector elements. The results are rounded. For truncated results, see SQSHRN.The SQRSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQRSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRSHRN Hd,Sn,#n</c></summary>
            [DebuggerStepThrough]
            public static Int16 vqrshrns_n_s32(Int32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounded Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, saturates each shifted result to a value that is half the original width, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are signed integer values. The destination vector elements are half as long as the source vector elements. The results are rounded. For truncated results, see SQSHRN.The SQRSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQRSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRSHRN Sd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqrshrnd_n_s64(Int64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Rounded Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values. The results are rounded. For truncated results, see UQSHRN.The UQRSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the UQRSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQRSHRN Bd,Hn,#n</c></summary>
            [DebuggerStepThrough]
            public static Byte vqrshrnh_n_u16(UInt16 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Rounded Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values. The results are rounded. For truncated results, see UQSHRN.The UQRSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the UQRSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQRSHRN Hd,Sn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vqrshrns_n_u32(UInt32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Rounded Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values. The results are rounded. For truncated results, see UQSHRN.The UQRSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the UQRSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQRSHRN Sd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vqrshrnd_n_u64(UInt64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounded Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, saturates each shifted result to a value that is half the original width, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are signed integer values. The destination vector elements are half as long as the source vector elements. The results are rounded. For truncated results, see SQSHRN.The SQRSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQRSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRSHRN2 Vd.16B,Vn.8H,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vqrshrn_high_n_s16(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounded Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, saturates each shifted result to a value that is half the original width, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are signed integer values. The destination vector elements are half as long as the source vector elements. The results are rounded. For truncated results, see SQSHRN.The SQRSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQRSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRSHRN2 Vd.8H,Vn.4S,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vqrshrn_high_n_s32(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounded Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, saturates each shifted result to a value that is half the original width, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are signed integer values. The destination vector elements are half as long as the source vector elements. The results are rounded. For truncated results, see SQSHRN.The SQRSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQRSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRSHRN2 Vd.4S,Vn.2D,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vqrshrn_high_n_s64(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Rounded Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values. The results are rounded. For truncated results, see UQSHRN.The UQRSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the UQRSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQRSHRN2 Vd.16B,Vn.8H,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vqrshrn_high_n_u16(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Rounded Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values. The results are rounded. For truncated results, see UQSHRN.The UQRSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the UQRSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQRSHRN2 Vd.8H,Vn.4S,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vqrshrn_high_n_u32(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating Rounded Shift Right Narrow (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each result by an immediate value, puts the final result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values. The results are rounded. For truncated results, see UQSHRN.The UQRSHRN instruction writes the vector to the lower half of the destination register and clears the upper half, while the UQRSHRN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQRSHRN2 Vd.4S,Vn.2D,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vqrshrn_high_n_u64(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Shift Left Long (immediate). This instruction reads each vector element from the source SIMD&amp;FP register, left shifts each vector element by the specified shift amount, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements. All the values in this instruction are signed integer values.The SSHLL instruction extracts vector elements from the lower half of the source register, while the SSHLL2 instruction extracts vector elements from the upper half of the source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SSHLL2 Vd.8H,Vn.16B,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vshll_high_n_s8(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Shift Left Long (immediate). This instruction reads each vector element from the source SIMD&amp;FP register, left shifts each vector element by the specified shift amount, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements. All the values in this instruction are signed integer values.The SSHLL instruction extracts vector elements from the lower half of the source register, while the SSHLL2 instruction extracts vector elements from the upper half of the source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SSHLL2 Vd.4S,Vn.8H,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vshll_high_n_s16(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Shift Left Long (immediate). This instruction reads each vector element from the source SIMD&amp;FP register, left shifts each vector element by the specified shift amount, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements. All the values in this instruction are signed integer values.The SSHLL instruction extracts vector elements from the lower half of the source register, while the SSHLL2 instruction extracts vector elements from the upper half of the source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SSHLL2 Vd.2D,Vn.4S,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vshll_high_n_s32(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Shift Left Long (immediate). This instruction reads each vector element in the lower or upper half of the source SIMD&amp;FP register, shifts the unsigned integer value left by the specified number of bits, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements.The USHLL instruction extracts vector elements from the lower half of the source register, while the USHLL2 instruction extracts vector elements from the upper half of the source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USHLL2 Vd.8H,Vn.16B,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vshll_high_n_u8(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Shift Left Long (immediate). This instruction reads each vector element in the lower or upper half of the source SIMD&amp;FP register, shifts the unsigned integer value left by the specified number of bits, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements.The USHLL instruction extracts vector elements from the lower half of the source register, while the USHLL2 instruction extracts vector elements from the upper half of the source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USHLL2 Vd.4S,Vn.8H,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vshll_high_n_u16(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Shift Left Long (immediate). This instruction reads each vector element in the lower or upper half of the source SIMD&amp;FP register, shifts the unsigned integer value left by the specified number of bits, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements.The USHLL instruction extracts vector elements from the lower half of the source register, while the USHLL2 instruction extracts vector elements from the upper half of the source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USHLL2 Vd.2D,Vn.4S,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vshll_high_n_u32(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Shift Right and Insert (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each vector element by an immediate value, and inserts the result into the corresponding vector element in the destination SIMD&amp;FP register such that the new zero bits created by the shift are not inserted but retain their existing value. Bits shifted out of the right of each vector element of the source register are lost.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SRI Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static Int64 vsrid_n_s64(Int64 a0, Int64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Shift Right and Insert (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, right shifts each vector element by an immediate value, and inserts the result into the corresponding vector element in the destination SIMD&amp;FP register such that the new zero bits created by the shift are not inserted but retain their existing value. Bits shifted out of the right of each vector element of the source register are lost.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SRI Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vsrid_n_u64(UInt64 a0, UInt64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Shift Left and Insert (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, left shifts each vector element by an immediate value, and inserts the result into the corresponding vector element in the destination SIMD&amp;FP register such that the new zero bits created by the shift are not inserted but retain their existing value. Bits shifted out of the left of each vector element in the source register are lost.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SLI Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static Int64 vslid_n_s64(Int64 a0, Int64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Shift Left and Insert (immediate). This instruction reads each vector element in the source SIMD&amp;FP register, left shifts each vector element by an immediate value, and inserts the result into the corresponding vector element in the destination SIMD&amp;FP register such that the new zero bits created by the shift are not inserted but retain their existing value. Bits shifted out of the left of each vector element in the source register are lost.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SLI Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vslid_n_u64(UInt64 a0, UInt64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding to nearest with ties to even (vector). This instruction converts a scalar or each element in a vector from a floating-point value to a signed integer value using the Round to Nearest rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTNS Vd.2S,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvtn_s32_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding to nearest with ties to even (vector). This instruction converts a scalar or each element in a vector from a floating-point value to a signed integer value using the Round to Nearest rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTNS Vd.4S,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtnq_s32_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding to nearest with ties to even (vector). This instruction converts a scalar or each element in a vector from a floating-point value to an unsigned integer value using the Round to Nearest rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTNU Vd.2S,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvtn_u32_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding to nearest with ties to even (vector). This instruction converts a scalar or each element in a vector from a floating-point value to an unsigned integer value using the Round to Nearest rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTNU Vd.4S,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtnq_u32_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding toward Minus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to a signed integer value using the Round towards Minus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTMS Vd.2S,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvtm_s32_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding toward Minus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to a signed integer value using the Round towards Minus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTMS Vd.4S,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtmq_s32_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding toward Minus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to an unsigned integer value using the Round towards Minus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTMU Vd.2S,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvtm_u32_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding toward Minus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to an unsigned integer value using the Round towards Minus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTMU Vd.4S,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtmq_u32_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding toward Plus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to a signed integer value using the Round towards Plus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTPS Vd.2S,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvtp_s32_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding toward Plus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to a signed integer value using the Round towards Plus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTPS Vd.4S,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtpq_s32_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding toward Plus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to an unsigned integer value using the Round towards Plus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTPU Vd.2S,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvtp_u32_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding toward Plus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to an unsigned integer value using the Round towards Plus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTPU Vd.4S,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtpq_u32_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding to nearest with ties to Away (vector). This instruction converts each element in a vector from a floating-point value to a signed integer value using the Round to Nearest with Ties to Away rounding mode and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTAS Vd.2S,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvta_s32_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding to nearest with ties to Away (vector). This instruction converts each element in a vector from a floating-point value to a signed integer value using the Round to Nearest with Ties to Away rounding mode and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTAS Vd.4S,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtaq_s32_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding to nearest with ties to Away (vector). This instruction converts each element in a vector from a floating-point value to an unsigned integer value using the Round to Nearest with Ties to Away rounding mode and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTAU Vd.2S,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvta_u32_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding to nearest with ties to Away (vector). This instruction converts each element in a vector from a floating-point value to an unsigned integer value using the Round to Nearest with Ties to Away rounding mode and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTAU Vd.4S,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtaq_u32_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed fixed-point, rounding toward Zero (vector). This instruction converts a scalar or each element in a vector from floating-point to fixed-point signed integer using the Round towards Zero rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTZS Sd,Sn</c></summary>
            [DebuggerStepThrough]
            public static Int32 vcvts_s32_f32(Single a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned fixed-point, rounding toward Zero (vector). This instruction converts a scalar or each element in a vector from floating-point to fixed-point unsigned integer using the Round towards Zero rounding mode, and writes the result to the general-purpose destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTZU Sd,Sn</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vcvts_u32_f32(Single a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding to nearest with ties to even (vector). This instruction converts a scalar or each element in a vector from a floating-point value to a signed integer value using the Round to Nearest rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTNS Sd,Sn</c></summary>
            [DebuggerStepThrough]
            public static Int32 vcvtns_s32_f32(Single a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding to nearest with ties to even (vector). This instruction converts a scalar or each element in a vector from a floating-point value to an unsigned integer value using the Round to Nearest rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTNU Sd,Sn</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vcvtns_u32_f32(Single a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding toward Minus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to a signed integer value using the Round towards Minus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTMS Sd,Sn</c></summary>
            [DebuggerStepThrough]
            public static Int32 vcvtms_s32_f32(Single a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding toward Minus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to an unsigned integer value using the Round towards Minus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTMU Sd,Sn</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vcvtms_u32_f32(Single a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding toward Plus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to a signed integer value using the Round towards Plus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTPS Sd,Sn</c></summary>
            [DebuggerStepThrough]
            public static Int32 vcvtps_s32_f32(Single a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding toward Plus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to an unsigned integer value using the Round towards Plus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTPU Sd,Sn</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vcvtps_u32_f32(Single a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding to nearest with ties to Away (vector). This instruction converts each element in a vector from a floating-point value to a signed integer value using the Round to Nearest with Ties to Away rounding mode and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTAS Sd,Sn</c></summary>
            [DebuggerStepThrough]
            public static Int32 vcvtas_s32_f32(Single a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding to nearest with ties to Away (vector). This instruction converts each element in a vector from a floating-point value to an unsigned integer value using the Round to Nearest with Ties to Away rounding mode and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTAU Sd,Sn</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vcvtas_u32_f32(Single a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed fixed-point, rounding toward Zero (vector). This instruction converts a scalar or each element in a vector from floating-point to fixed-point signed integer using the Round towards Zero rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTZS Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvt_s64_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed fixed-point, rounding toward Zero (vector). This instruction converts a scalar or each element in a vector from floating-point to fixed-point signed integer using the Round towards Zero rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTZS Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtq_s64_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned fixed-point, rounding toward Zero (vector). This instruction converts a scalar or each element in a vector from floating-point to fixed-point unsigned integer using the Round towards Zero rounding mode, and writes the result to the general-purpose destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTZU Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvt_u64_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned fixed-point, rounding toward Zero (vector). This instruction converts a scalar or each element in a vector from floating-point to fixed-point unsigned integer using the Round towards Zero rounding mode, and writes the result to the general-purpose destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTZU Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtq_u64_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding to nearest with ties to even (vector). This instruction converts a scalar or each element in a vector from a floating-point value to a signed integer value using the Round to Nearest rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTNS Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvtn_s64_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding to nearest with ties to even (vector). This instruction converts a scalar or each element in a vector from a floating-point value to a signed integer value using the Round to Nearest rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTNS Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtnq_s64_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding to nearest with ties to even (vector). This instruction converts a scalar or each element in a vector from a floating-point value to an unsigned integer value using the Round to Nearest rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTNU Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvtn_u64_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding to nearest with ties to even (vector). This instruction converts a scalar or each element in a vector from a floating-point value to an unsigned integer value using the Round to Nearest rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTNU Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtnq_u64_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding toward Minus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to a signed integer value using the Round towards Minus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTMS Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvtm_s64_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding toward Minus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to a signed integer value using the Round towards Minus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTMS Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtmq_s64_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding toward Minus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to an unsigned integer value using the Round towards Minus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTMU Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvtm_u64_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding toward Minus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to an unsigned integer value using the Round towards Minus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTMU Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtmq_u64_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding toward Plus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to a signed integer value using the Round towards Plus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTPS Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvtp_s64_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding toward Plus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to a signed integer value using the Round towards Plus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTPS Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtpq_s64_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding toward Plus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to an unsigned integer value using the Round towards Plus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTPU Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvtp_u64_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding toward Plus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to an unsigned integer value using the Round towards Plus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTPU Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtpq_u64_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding to nearest with ties to Away (vector). This instruction converts each element in a vector from a floating-point value to a signed integer value using the Round to Nearest with Ties to Away rounding mode and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTAS Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvta_s64_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding to nearest with ties to Away (vector). This instruction converts each element in a vector from a floating-point value to a signed integer value using the Round to Nearest with Ties to Away rounding mode and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTAS Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtaq_s64_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding to nearest with ties to Away (vector). This instruction converts each element in a vector from a floating-point value to an unsigned integer value using the Round to Nearest with Ties to Away rounding mode and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTAU Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvta_u64_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding to nearest with ties to Away (vector). This instruction converts each element in a vector from a floating-point value to an unsigned integer value using the Round to Nearest with Ties to Away rounding mode and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTAU Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtaq_u64_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed fixed-point, rounding toward Zero (vector). This instruction converts a scalar or each element in a vector from floating-point to fixed-point signed integer using the Round towards Zero rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTZS Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static Int64 vcvtd_s64_f64(Double a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned fixed-point, rounding toward Zero (vector). This instruction converts a scalar or each element in a vector from floating-point to fixed-point unsigned integer using the Round towards Zero rounding mode, and writes the result to the general-purpose destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTZU Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcvtd_u64_f64(Double a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding to nearest with ties to even (vector). This instruction converts a scalar or each element in a vector from a floating-point value to a signed integer value using the Round to Nearest rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTNS Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static Int64 vcvtnd_s64_f64(Double a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding to nearest with ties to even (vector). This instruction converts a scalar or each element in a vector from a floating-point value to an unsigned integer value using the Round to Nearest rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTNU Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcvtnd_u64_f64(Double a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding toward Minus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to a signed integer value using the Round towards Minus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTMS Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static Int64 vcvtmd_s64_f64(Double a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding toward Minus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to an unsigned integer value using the Round towards Minus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTMU Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcvtmd_u64_f64(Double a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding toward Plus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to a signed integer value using the Round towards Plus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTPS Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static Int64 vcvtpd_s64_f64(Double a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding toward Plus infinity (vector). This instruction converts a scalar or each element in a vector from a floating-point value to an unsigned integer value using the Round towards Plus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTPU Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcvtpd_u64_f64(Double a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed integer, rounding to nearest with ties to Away (vector). This instruction converts each element in a vector from a floating-point value to a signed integer value using the Round to Nearest with Ties to Away rounding mode and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTAS Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static Int64 vcvtad_s64_f64(Double a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned integer, rounding to nearest with ties to Away (vector). This instruction converts each element in a vector from a floating-point value to an unsigned integer value using the Round to Nearest with Ties to Away rounding mode and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTAU Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcvtad_u64_f64(Double a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed fixed-point, rounding toward Zero (vector). This instruction converts a scalar or each element in a vector from floating-point to fixed-point signed integer using the Round towards Zero rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTZS Sd,Sn,#n</c></summary>
            [DebuggerStepThrough]
            public static Int32 vcvts_n_s32_f32(Single a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned fixed-point, rounding toward Zero (vector). This instruction converts a scalar or each element in a vector from floating-point to fixed-point unsigned integer using the Round towards Zero rounding mode, and writes the result to the general-purpose destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTZU Sd,Sn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vcvts_n_u32_f32(Single a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed fixed-point, rounding toward Zero (vector). This instruction converts a scalar or each element in a vector from floating-point to fixed-point signed integer using the Round towards Zero rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTZS Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvt_n_s64_f64(v64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed fixed-point, rounding toward Zero (vector). This instruction converts a scalar or each element in a vector from floating-point to fixed-point signed integer using the Round towards Zero rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTZS Vd.2D,Vn.2D,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtq_n_s64_f64(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned fixed-point, rounding toward Zero (vector). This instruction converts a scalar or each element in a vector from floating-point to fixed-point unsigned integer using the Round towards Zero rounding mode, and writes the result to the general-purpose destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTZU Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvt_n_u64_f64(v64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned fixed-point, rounding toward Zero (vector). This instruction converts a scalar or each element in a vector from floating-point to fixed-point unsigned integer using the Round towards Zero rounding mode, and writes the result to the general-purpose destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTZU Vd.2D,Vn.2D,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtq_n_u64_f64(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Signed fixed-point, rounding toward Zero (vector). This instruction converts a scalar or each element in a vector from floating-point to fixed-point signed integer using the Round towards Zero rounding mode, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTZS Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static Int64 vcvtd_n_s64_f64(Double a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to Unsigned fixed-point, rounding toward Zero (vector). This instruction converts a scalar or each element in a vector from floating-point to fixed-point unsigned integer using the Round towards Zero rounding mode, and writes the result to the general-purpose destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTZU Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vcvtd_n_u64_f64(Double a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed fixed-point Convert to Floating-point (vector). This instruction converts each element in a vector from fixed-point to floating-point using the rounding mode that is specified by the FPCR, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SCVTF Sd,Sn</c></summary>
            [DebuggerStepThrough]
            public static Single vcvts_f32_s32(Int32 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned fixed-point Convert to Floating-point (vector). This instruction converts each element in a vector from fixed-point to floating-point using the rounding mode that is specified by the FPCR, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UCVTF Sd,Sn</c></summary>
            [DebuggerStepThrough]
            public static Single vcvts_f32_u32(UInt32 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed fixed-point Convert to Floating-point (vector). This instruction converts each element in a vector from fixed-point to floating-point using the rounding mode that is specified by the FPCR, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SCVTF Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvt_f64_s64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed fixed-point Convert to Floating-point (vector). This instruction converts each element in a vector from fixed-point to floating-point using the rounding mode that is specified by the FPCR, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SCVTF Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtq_f64_s64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned fixed-point Convert to Floating-point (vector). This instruction converts each element in a vector from fixed-point to floating-point using the rounding mode that is specified by the FPCR, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UCVTF Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvt_f64_u64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned fixed-point Convert to Floating-point (vector). This instruction converts each element in a vector from fixed-point to floating-point using the rounding mode that is specified by the FPCR, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UCVTF Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtq_f64_u64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed fixed-point Convert to Floating-point (vector). This instruction converts each element in a vector from fixed-point to floating-point using the rounding mode that is specified by the FPCR, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SCVTF Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static Double vcvtd_f64_s64(Int64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned fixed-point Convert to Floating-point (vector). This instruction converts each element in a vector from fixed-point to floating-point using the rounding mode that is specified by the FPCR, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UCVTF Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static Double vcvtd_f64_u64(UInt64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed fixed-point Convert to Floating-point (vector). This instruction converts each element in a vector from fixed-point to floating-point using the rounding mode that is specified by the FPCR, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SCVTF Sd,Sn,#n</c></summary>
            [DebuggerStepThrough]
            public static Single vcvts_n_f32_s32(Int32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned fixed-point Convert to Floating-point (vector). This instruction converts each element in a vector from fixed-point to floating-point using the rounding mode that is specified by the FPCR, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UCVTF Sd,Sn,#n</c></summary>
            [DebuggerStepThrough]
            public static Single vcvts_n_f32_u32(UInt32 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed fixed-point Convert to Floating-point (vector). This instruction converts each element in a vector from fixed-point to floating-point using the rounding mode that is specified by the FPCR, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SCVTF Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvt_n_f64_s64(v64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed fixed-point Convert to Floating-point (vector). This instruction converts each element in a vector from fixed-point to floating-point using the rounding mode that is specified by the FPCR, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SCVTF Vd.2D,Vn.2D,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtq_n_f64_s64(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned fixed-point Convert to Floating-point (vector). This instruction converts each element in a vector from fixed-point to floating-point using the rounding mode that is specified by the FPCR, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UCVTF Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvt_n_f64_u64(v64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned fixed-point Convert to Floating-point (vector). This instruction converts each element in a vector from fixed-point to floating-point using the rounding mode that is specified by the FPCR, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UCVTF Vd.2D,Vn.2D,#n</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtq_n_f64_u64(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed fixed-point Convert to Floating-point (vector). This instruction converts each element in a vector from fixed-point to floating-point using the rounding mode that is specified by the FPCR, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SCVTF Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static Double vcvtd_n_f64_s64(Int64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned fixed-point Convert to Floating-point (vector). This instruction converts each element in a vector from fixed-point to floating-point using the rounding mode that is specified by the FPCR, and writes the result to the SIMD&amp;FP destination register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UCVTF Dd,Dn,#n</c></summary>
            [DebuggerStepThrough]
            public static Double vcvtd_n_f64_u64(UInt64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to lower precision Narrow (vector). This instruction reads each vector element in the SIMD&amp;FP source register, converts each result to half the precision of the source element, writes the final result to a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. The rounding mode is determined by the FPCR.The FCVTN instruction writes the vector to the lower half of the destination register and clears the upper half, while the FCVTN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the Security state and Exception level in which the instruction is executed, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTN Vd.2S,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvt_f32_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to lower precision Narrow (vector). This instruction reads each vector element in the SIMD&FP source register, converts each result to half the precision of the source element, writes the final result to a vector, and writes the vector to the lower or upper half of the destination SIMD&FP register. The destination vector elements are half as long as the source vector elements. The rounding mode is determined by the FPCR.
            /// <br/>Equivalent instruction: <c>FCVTN2 Vd.4S,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvt_high_f32_f64(v64 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to higher precision Long (vector). This instruction reads each element in a vector in the SIMD&amp;FP source register, converts each value to double the precision of the source element using the rounding mode that is determined by the FPCR, and writes each result to the equivalent element of the vector in the SIMD&amp;FP destination register.Where the operation lengthens a 64-bit vector to a 128-bit vector, the FCVTL2 variant operates on the elements in the top 64 bits of the source register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTL Vd.2D,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvt_f64_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to higher precision Long (vector). This instruction reads each element in a vector in the SIMD&amp;FP source register, converts each value to double the precision of the source element using the rounding mode that is determined by the FPCR, and writes each result to the equivalent element of the vector in the SIMD&amp;FP destination register.Where the operation lengthens a 64-bit vector to a 128-bit vector, the FCVTL2 variant operates on the elements in the top 64 bits of the source register.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTL2 Vd.2D,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvt_high_f64_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to lower precision Narrow, rounding to odd (vector). This instruction reads each vector element in the source SIMD&amp;FP register, narrows each value to half the precision of the source element using the Round to Odd rounding mode, writes the result to a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction uses the Round to Odd rounding mode which is not defined by the IEEE 754-2008 standard. This rounding mode ensures that if the result of the conversion is inexact the least significant bit of the mantissa is forced to 1. This rounding mode enables a floating-point value to be converted to a lower precision format via an intermediate precision format while avoiding double rounding errors. For example, a 64-bit floating-point value can be converted to a correctly rounded 16-bit floating-point value by first using this instruction to produce a 32-bit value and then using another instruction with the wanted rounding mode to convert the 32-bit value to the final 16-bit floating-point value.The FCVTXN instruction writes the vector to the lower half of the destination register and clears the upper half, while the FCVTXN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTXN Vd.2S,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v64 vcvtx_f32_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to lower precision Narrow, rounding to odd (vector). This instruction reads each vector element in the source SIMD&amp;FP register, narrows each value to half the precision of the source element using the Round to Odd rounding mode, writes the result to a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction uses the Round to Odd rounding mode which is not defined by the IEEE 754-2008 standard. This rounding mode ensures that if the result of the conversion is inexact the least significant bit of the mantissa is forced to 1. This rounding mode enables a floating-point value to be converted to a lower precision format via an intermediate precision format while avoiding double rounding errors. For example, a 64-bit floating-point value can be converted to a correctly rounded 16-bit floating-point value by first using this instruction to produce a 32-bit value and then using another instruction with the wanted rounding mode to convert the 32-bit value to the final 16-bit floating-point value.The FCVTXN instruction writes the vector to the lower half of the destination register and clears the upper half, while the FCVTXN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTXN Sd,Dn</c></summary>
            [DebuggerStepThrough]
            public static Single vcvtxd_f32_f64(Double a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Convert to lower precision Narrow, rounding to odd (vector). This instruction reads each vector element in the source SIMD&amp;FP register, narrows each value to half the precision of the source element using the Round to Odd rounding mode, writes the result to a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction uses the Round to Odd rounding mode which is not defined by the IEEE 754-2008 standard. This rounding mode ensures that if the result of the conversion is inexact the least significant bit of the mantissa is forced to 1. This rounding mode enables a floating-point value to be converted to a lower precision format via an intermediate precision format while avoiding double rounding errors. For example, a 64-bit floating-point value can be converted to a correctly rounded 16-bit floating-point value by first using this instruction to produce a 32-bit value and then using another instruction with the wanted rounding mode to convert the 32-bit value to the final 16-bit floating-point value.The FCVTXN instruction writes the vector to the lower half of the destination register and clears the upper half, while the FCVTXN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FCVTXN2 Vd.4S,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vcvtx_high_f32_f64(v64 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, toward Zero (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round towards Zero rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTZ Vd.2S,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vrnd_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, toward Zero (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round towards Zero rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTZ Vd.4S,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vrndq_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, toward Zero (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round towards Zero rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTZ Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vrnd_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, toward Zero (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round towards Zero rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTZ Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vrndq_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, to nearest with ties to even (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round to Nearest rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTN Vd.2S,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vrndn_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, to nearest with ties to even (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round to Nearest rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTN Vd.4S,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vrndnq_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, to nearest with ties to even (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round to Nearest rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTN Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vrndn_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, to nearest with ties to even (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round to Nearest rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTN Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vrndnq_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, to nearest with ties to even (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round to Nearest rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTN Sd,Sn</c></summary>
            [DebuggerStepThrough]
            public static Single vrndns_f32(Single a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, toward Minus infinity (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round towards Minus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTM Vd.2S,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vrndm_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, toward Minus infinity (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round towards Minus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTM Vd.4S,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vrndmq_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, toward Minus infinity (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round towards Minus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTM Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vrndm_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, toward Minus infinity (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round towards Minus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTM Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vrndmq_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, toward Plus infinity (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round towards Plus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTP Vd.2S,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vrndp_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, toward Plus infinity (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round towards Plus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTP Vd.4S,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vrndpq_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, toward Plus infinity (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round towards Plus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTP Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vrndp_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, toward Plus infinity (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round towards Plus Infinity rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTP Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vrndpq_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, to nearest with ties to Away (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round to Nearest with Ties to Away rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTA Vd.2S,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vrnda_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, to nearest with ties to Away (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round to Nearest with Ties to Away rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTA Vd.4S,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vrndaq_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, to nearest with ties to Away (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round to Nearest with Ties to Away rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTA Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vrnda_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, to nearest with ties to Away (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the Round to Nearest with Ties to Away rounding mode, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTA Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vrndaq_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, using current rounding mode (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the rounding mode that is determined by the FPCR, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTI Vd.2S,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vrndi_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, using current rounding mode (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the rounding mode that is determined by the FPCR, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTI Vd.4S,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vrndiq_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, using current rounding mode (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the rounding mode that is determined by the FPCR, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTI Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vrndi_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral, using current rounding mode (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the rounding mode that is determined by the FPCR, and writes the result to the SIMD&amp;FP destination register.A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTI Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vrndiq_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral exact, using current rounding mode (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the rounding mode that is determined by the FPCR, and writes the result to the SIMD&amp;FP destination register.When a result value is not numerically equal to the corresponding input value, an Inexact exception is raised. A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTX Vd.2S,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vrndx_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral exact, using current rounding mode (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the rounding mode that is determined by the FPCR, and writes the result to the SIMD&amp;FP destination register.When a result value is not numerically equal to the corresponding input value, an Inexact exception is raised. A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTX Vd.4S,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vrndxq_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral exact, using current rounding mode (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the rounding mode that is determined by the FPCR, and writes the result to the SIMD&amp;FP destination register.When a result value is not numerically equal to the corresponding input value, an Inexact exception is raised. A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTX Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vrndx_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Round to Integral exact, using current rounding mode (vector). This instruction rounds a vector of floating-point values in the SIMD&amp;FP source register to integral floating-point values of the same size using the rounding mode that is determined by the FPCR, and writes the result to the SIMD&amp;FP destination register.When a result value is not numerically equal to the corresponding input value, an Inexact exception is raised. A zero input gives a zero result with the same sign, an infinite input gives an infinite result with the same sign, and a NaN is propagated as for normal arithmetic.A floating-point exception can be generated by this instruction. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRINTX Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vrndxq_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating extract Narrow. This instruction reads each vector element from the source SIMD&amp;FP register, saturates the value to half the original width, places the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQXTN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQXTN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>XTN2 Vd.16B,Vn.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vmovn_high_s16(v64 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating extract Narrow. This instruction reads each vector element from the source SIMD&amp;FP register, saturates the value to half the original width, places the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQXTN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQXTN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>XTN2 Vd.8H,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vmovn_high_s32(v64 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating extract Narrow. This instruction reads each vector element from the source SIMD&amp;FP register, saturates the value to half the original width, places the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQXTN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQXTN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>XTN2 Vd.4S,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vmovn_high_s64(v64 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating extract Narrow. This instruction reads each vector element from the source SIMD&amp;FP register, saturates the value to half the original width, places the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQXTN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQXTN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>XTN2 Vd.16B,Vn.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vmovn_high_u16(v64 a0, v128 a1)
            {
                return vmovn_high_s16(a0, a1);
            }

            /// <summary>Signed saturating extract Narrow. This instruction reads each vector element from the source SIMD&amp;FP register, saturates the value to half the original width, places the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQXTN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQXTN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>XTN2 Vd.8H,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vmovn_high_u32(v64 a0, v128 a1)
            {
                return vmovn_high_s32(a0, a1);
            }

            /// <summary>Signed saturating extract Narrow. This instruction reads each vector element from the source SIMD&amp;FP register, saturates the value to half the original width, places the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQXTN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQXTN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>XTN2 Vd.4S,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vmovn_high_u64(v64 a0, v128 a1)
            {
                return vmovn_high_s64(a0, a1);
            }

            /// <summary>Signed Shift Left Long (immediate). This instruction reads each vector element from the source SIMD&amp;FP register, left shifts each vector element by the specified shift amount, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements. All the values in this instruction are signed integer values.The SSHLL instruction extracts vector elements from the lower half of the source register, while the SSHLL2 instruction extracts vector elements from the upper half of the source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SSHLL2 Vd.8H,Vn.16B,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vmovl_high_s8(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Shift Left Long (immediate). This instruction reads each vector element from the source SIMD&amp;FP register, left shifts each vector element by the specified shift amount, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements. All the values in this instruction are signed integer values.The SSHLL instruction extracts vector elements from the lower half of the source register, while the SSHLL2 instruction extracts vector elements from the upper half of the source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SSHLL2 Vd.4S,Vn.8H,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vmovl_high_s16(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Shift Left Long (immediate). This instruction reads each vector element from the source SIMD&amp;FP register, left shifts each vector element by the specified shift amount, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements. All the values in this instruction are signed integer values.The SSHLL instruction extracts vector elements from the lower half of the source register, while the SSHLL2 instruction extracts vector elements from the upper half of the source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SSHLL2 Vd.2D,Vn.4S,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vmovl_high_s32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Shift Left Long (immediate). This instruction reads each vector element in the lower or upper half of the source SIMD&amp;FP register, shifts the unsigned integer value left by the specified number of bits, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements.The USHLL instruction extracts vector elements from the lower half of the source register, while the USHLL2 instruction extracts vector elements from the upper half of the source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USHLL2 Vd.8H,Vn.16B,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vmovl_high_u8(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Shift Left Long (immediate). This instruction reads each vector element in the lower or upper half of the source SIMD&amp;FP register, shifts the unsigned integer value left by the specified number of bits, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements.The USHLL instruction extracts vector elements from the lower half of the source register, while the USHLL2 instruction extracts vector elements from the upper half of the source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USHLL2 Vd.4S,Vn.8H,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vmovl_high_u16(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Shift Left Long (immediate). This instruction reads each vector element in the lower or upper half of the source SIMD&amp;FP register, shifts the unsigned integer value left by the specified number of bits, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements.The USHLL instruction extracts vector elements from the lower half of the source register, while the USHLL2 instruction extracts vector elements from the upper half of the source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>USHLL2 Vd.2D,Vn.4S,#0</c></summary>
            [DebuggerStepThrough]
            public static v128 vmovl_high_u32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating extract Narrow. This instruction reads each vector element from the source SIMD&amp;FP register, saturates the value to half the original width, places the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQXTN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQXTN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQXTN Bd,Hn</c></summary>
            [DebuggerStepThrough]
            public static SByte vqmovnh_s16(Int16 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating extract Narrow. This instruction reads each vector element from the source SIMD&amp;FP register, saturates the value to half the original width, places the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQXTN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQXTN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQXTN Hd,Sn</c></summary>
            [DebuggerStepThrough]
            public static Int16 vqmovns_s32(Int32 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating extract Narrow. This instruction reads each vector element from the source SIMD&amp;FP register, saturates the value to half the original width, places the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQXTN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQXTN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQXTN Sd,Dn</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqmovnd_s64(Int64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating extract Narrow. This instruction reads each vector element from the source SIMD&amp;FP register, saturates each value to half the original width, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.If saturation occurs, the cumulative saturation bit FPSR.QC is set.The UQXTN instruction writes the vector to the lower half of the destination register and clears the upper half, while the UQXTN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQXTN Bd,Hn</c></summary>
            [DebuggerStepThrough]
            public static Byte vqmovnh_u16(UInt16 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating extract Narrow. This instruction reads each vector element from the source SIMD&amp;FP register, saturates each value to half the original width, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.If saturation occurs, the cumulative saturation bit FPSR.QC is set.The UQXTN instruction writes the vector to the lower half of the destination register and clears the upper half, while the UQXTN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQXTN Hd,Sn</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vqmovns_u32(UInt32 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating extract Narrow. This instruction reads each vector element from the source SIMD&amp;FP register, saturates each value to half the original width, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.If saturation occurs, the cumulative saturation bit FPSR.QC is set.The UQXTN instruction writes the vector to the lower half of the destination register and clears the upper half, while the UQXTN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQXTN Sd,Dn</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vqmovnd_u64(UInt64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating extract Narrow. This instruction reads each vector element from the source SIMD&amp;FP register, saturates the value to half the original width, places the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQXTN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQXTN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQXTN2 Vd.16B,Vn.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vqmovn_high_s16(v64 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating extract Narrow. This instruction reads each vector element from the source SIMD&amp;FP register, saturates the value to half the original width, places the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQXTN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQXTN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQXTN2 Vd.8H,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vqmovn_high_s32(v64 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating extract Narrow. This instruction reads each vector element from the source SIMD&amp;FP register, saturates the value to half the original width, places the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQXTN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQXTN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQXTN2 Vd.4S,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vqmovn_high_s64(v64 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating extract Narrow. This instruction reads each vector element from the source SIMD&amp;FP register, saturates each value to half the original width, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.If saturation occurs, the cumulative saturation bit FPSR.QC is set.The UQXTN instruction writes the vector to the lower half of the destination register and clears the upper half, while the UQXTN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQXTN2 Vd.16B,Vn.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vqmovn_high_u16(v64 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating extract Narrow. This instruction reads each vector element from the source SIMD&amp;FP register, saturates each value to half the original width, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.If saturation occurs, the cumulative saturation bit FPSR.QC is set.The UQXTN instruction writes the vector to the lower half of the destination register and clears the upper half, while the UQXTN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQXTN2 Vd.8H,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vqmovn_high_u32(v64 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned saturating extract Narrow. This instruction reads each vector element from the source SIMD&amp;FP register, saturates each value to half the original width, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.If saturation occurs, the cumulative saturation bit FPSR.QC is set.The UQXTN instruction writes the vector to the lower half of the destination register and clears the upper half, while the UQXTN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UQXTN2 Vd.4S,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vqmovn_high_u64(v64 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating extract Unsigned Narrow. This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, saturates the value to an unsigned integer value that is half the original width, places the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements.If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQXTUN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQXTUN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQXTUN Bd,Hn</c></summary>
            [DebuggerStepThrough]
            public static Byte vqmovunh_s16(Int16 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating extract Unsigned Narrow. This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, saturates the value to an unsigned integer value that is half the original width, places the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements.If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQXTUN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQXTUN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQXTUN Hd,Sn</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vqmovuns_s32(Int32 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating extract Unsigned Narrow. This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, saturates the value to an unsigned integer value that is half the original width, places the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements.If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQXTUN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQXTUN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQXTUN Sd,Dn</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vqmovund_s64(Int64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating extract Unsigned Narrow. This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, saturates the value to an unsigned integer value that is half the original width, places the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements.If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQXTUN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQXTUN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQXTUN2 Vd.16B,Vn.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vqmovun_high_s16(v64 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating extract Unsigned Narrow. This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, saturates the value to an unsigned integer value that is half the original width, places the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements.If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQXTUN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQXTUN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQXTUN2 Vd.8H,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vqmovun_high_s32(v64 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating extract Unsigned Narrow. This instruction reads each signed integer value in the vector of the source SIMD&amp;FP register, saturates the value to an unsigned integer value that is half the original width, places the result into a vector, and writes the vector to the lower or upper half of the destination SIMD&amp;FP register. The destination vector elements are half as long as the source vector elements.If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQXTUN instruction writes the vector to the lower half of the destination register and clears the upper half, while the SQXTUN2 instruction writes the vector to the upper half of the destination register without affecting the other bits of the register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQXTUN2 Vd.4S,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vqmovun_high_s64(v64 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply-Add to accumulator (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results with the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MLA Vd.4H,Vn.4H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmla_laneq_s16(v64 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply-Add to accumulator (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results with the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MLA Vd.8H,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlaq_laneq_s16(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply-Add to accumulator (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results with the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MLA Vd.2S,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmla_laneq_s32(v64 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply-Add to accumulator (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results with the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MLA Vd.4S,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlaq_laneq_s32(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply-Add to accumulator (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results with the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MLA Vd.4H,Vn.4H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmla_laneq_u16(v64 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply-Add to accumulator (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results with the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MLA Vd.8H,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlaq_laneq_u16(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply-Add to accumulator (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results with the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MLA Vd.2S,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmla_laneq_u32(v64 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply-Add to accumulator (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and accumulates the results with the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MLA Vd.4S,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlaq_laneq_u32(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>
            /// <br/>Equivalent instruction: <c>RESULT[I] = a[i] + (b[i] * v[lane]) for i = 0 to 1</c></summary>
            [DebuggerStepThrough]
            public static v64 vmla_laneq_f32(v64 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>
            /// <br/>Equivalent instruction: <c>RESULT[I] = a[i] + (b[i] * v[lane]) for i = 0 to 3</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlaq_laneq_f32(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element in the second source SIMD&amp;FP register, and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.The SMLAL instruction extracts vector elements from the lower half of the first source register, while the SMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLAL2 Vd.4S,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_high_lane_s16(v128 a0, v128 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element in the second source SIMD&amp;FP register, and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.The SMLAL instruction extracts vector elements from the lower half of the first source register, while the SMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLAL2 Vd.2D,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_high_lane_s32(v128 a0, v128 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLAL instruction extracts vector elements from the lower half of the first source register, while the UMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLAL2 Vd.4S,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_high_lane_u16(v128 a0, v128 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLAL instruction extracts vector elements from the lower half of the first source register, while the UMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLAL2 Vd.2D,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_high_lane_u32(v128 a0, v128 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element in the second source SIMD&amp;FP register, and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.The SMLAL instruction extracts vector elements from the lower half of the first source register, while the SMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLAL Vd.4S,Vn.4H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_laneq_s16(v128 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element in the second source SIMD&amp;FP register, and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.The SMLAL instruction extracts vector elements from the lower half of the first source register, while the SMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLAL Vd.2D,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_laneq_s32(v128 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLAL instruction extracts vector elements from the lower half of the first source register, while the UMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLAL Vd.4S,Vn.4H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_laneq_u16(v128 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLAL instruction extracts vector elements from the lower half of the first source register, while the UMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLAL Vd.2D,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_laneq_u32(v128 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element in the second source SIMD&amp;FP register, and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.The SMLAL instruction extracts vector elements from the lower half of the first source register, while the SMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLAL2 Vd.4S,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_high_laneq_s16(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element in the second source SIMD&amp;FP register, and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.The SMLAL instruction extracts vector elements from the lower half of the first source register, while the SMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLAL2 Vd.2D,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_high_laneq_s32(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLAL instruction extracts vector elements from the lower half of the first source register, while the UMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLAL2 Vd.4S,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_high_laneq_u16(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLAL instruction extracts vector elements from the lower half of the first source register, while the UMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLAL2 Vd.2D,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_high_laneq_u32(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Add Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLAL instruction extracts vector elements from the lower half of the first source register, while the SQDMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLAL Sd,Hn,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqdmlalh_lane_s16(Int32 a0, Int16 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Add Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLAL instruction extracts vector elements from the lower half of the first source register, while the SQDMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLAL Dd,Sn,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int64 vqdmlals_lane_s32(Int64 a0, Int32 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Add Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLAL instruction extracts vector elements from the lower half of the first source register, while the SQDMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLAL2 Vd.4S,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlal_high_lane_s16(v128 a0, v128 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Add Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLAL instruction extracts vector elements from the lower half of the first source register, while the SQDMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLAL2 Vd.2D,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlal_high_lane_s32(v128 a0, v128 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Add Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLAL instruction extracts vector elements from the lower half of the first source register, while the SQDMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLAL Vd.4S,Vn.4H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlal_laneq_s16(v128 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Add Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLAL instruction extracts vector elements from the lower half of the first source register, while the SQDMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLAL Vd.2D,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlal_laneq_s32(v128 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Add Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLAL instruction extracts vector elements from the lower half of the first source register, while the SQDMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLAL Sd,Hn,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqdmlalh_laneq_s16(Int32 a0, Int16 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Add Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLAL instruction extracts vector elements from the lower half of the first source register, while the SQDMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLAL Dd,Sn,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int64 vqdmlals_laneq_s32(Int64 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Add Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLAL instruction extracts vector elements from the lower half of the first source register, while the SQDMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLAL2 Vd.4S,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlal_high_laneq_s16(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Add Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLAL instruction extracts vector elements from the lower half of the first source register, while the SQDMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLAL2 Vd.2D,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlal_high_laneq_s32(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply-Subtract from accumulator (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MLS Vd.4H,Vn.4H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmls_laneq_s16(v64 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply-Subtract from accumulator (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MLS Vd.8H,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsq_laneq_s16(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply-Subtract from accumulator (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MLS Vd.2S,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmls_laneq_s32(v64 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply-Subtract from accumulator (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MLS Vd.4S,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsq_laneq_s32(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply-Subtract from accumulator (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MLS Vd.4H,Vn.4H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmls_laneq_u16(v64 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply-Subtract from accumulator (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MLS Vd.8H,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsq_laneq_u16(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply-Subtract from accumulator (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MLS Vd.2S,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmls_laneq_u32(v64 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply-Subtract from accumulator (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, and subtracts the results from the vector elements of the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MLS Vd.4S,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsq_laneq_u32(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>
            /// <br/>Equivalent instruction: <c>RESULT[I] = a[i] - (b[i] * v[lane]) for i = 0 to 1</c></summary>
            [DebuggerStepThrough]
            public static v64 vmls_laneq_f32(v64 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>
            /// <br/>Equivalent instruction: <c>RESULT[I] = a[i] - (b[i] * v[lane]) for i = 0 to 3</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsq_laneq_f32(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMLSL instruction extracts vector elements from the lower half of the first source register, while the SMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLSL2 Vd.4S,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_high_lane_s16(v128 a0, v128 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMLSL instruction extracts vector elements from the lower half of the first source register, while the SMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLSL2 Vd.2D,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_high_lane_s32(v128 a0, v128 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLSL instruction extracts vector elements from the lower half of the first source register, while the UMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLSL2 Vd.4S,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_high_lane_u16(v128 a0, v128 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLSL instruction extracts vector elements from the lower half of the first source register, while the UMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLSL2 Vd.2D,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_high_lane_u32(v128 a0, v128 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMLSL instruction extracts vector elements from the lower half of the first source register, while the SMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLSL Vd.4S,Vn.4H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_laneq_s16(v128 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMLSL instruction extracts vector elements from the lower half of the first source register, while the SMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLSL Vd.2D,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_laneq_s32(v128 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLSL instruction extracts vector elements from the lower half of the first source register, while the UMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLSL Vd.4S,Vn.4H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_laneq_u16(v128 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLSL instruction extracts vector elements from the lower half of the first source register, while the UMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLSL Vd.2D,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_laneq_u32(v128 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMLSL instruction extracts vector elements from the lower half of the first source register, while the SMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLSL2 Vd.4S,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_high_laneq_s16(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMLSL instruction extracts vector elements from the lower half of the first source register, while the SMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLSL2 Vd.2D,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_high_laneq_s32(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLSL instruction extracts vector elements from the lower half of the first source register, while the UMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLSL2 Vd.4S,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_high_laneq_u16(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLSL instruction extracts vector elements from the lower half of the first source register, while the UMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLSL2 Vd.2D,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_high_laneq_u32(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Subtract Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and subtracts the final results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLSL instruction extracts vector elements from the lower half of the first source register, while the SQDMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLSL Sd,Hn,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqdmlslh_lane_s16(Int32 a0, Int16 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Subtract Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and subtracts the final results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLSL instruction extracts vector elements from the lower half of the first source register, while the SQDMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLSL Dd,Sn,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int64 vqdmlsls_lane_s32(Int64 a0, Int32 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Subtract Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and subtracts the final results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLSL instruction extracts vector elements from the lower half of the first source register, while the SQDMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLSL2 Vd.4S,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlsl_high_lane_s16(v128 a0, v128 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Subtract Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and subtracts the final results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLSL instruction extracts vector elements from the lower half of the first source register, while the SQDMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLSL2 Vd.2D,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlsl_high_lane_s32(v128 a0, v128 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Subtract Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and subtracts the final results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLSL instruction extracts vector elements from the lower half of the first source register, while the SQDMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLSL Vd.4S,Vn.4H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlsl_laneq_s16(v128 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Subtract Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and subtracts the final results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLSL instruction extracts vector elements from the lower half of the first source register, while the SQDMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLSL Vd.2D,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlsl_laneq_s32(v128 a0, v64 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Subtract Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and subtracts the final results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLSL instruction extracts vector elements from the lower half of the first source register, while the SQDMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLSL Sd,Hn,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqdmlslh_laneq_s16(Int32 a0, Int16 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Subtract Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and subtracts the final results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLSL instruction extracts vector elements from the lower half of the first source register, while the SQDMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLSL Dd,Sn,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int64 vqdmlsls_laneq_s32(Int64 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Subtract Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and subtracts the final results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLSL instruction extracts vector elements from the lower half of the first source register, while the SQDMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLSL2 Vd.4S,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlsl_high_laneq_s16(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Subtract Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and subtracts the final results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLSL instruction extracts vector elements from the lower half of the first source register, while the SQDMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLSL2 Vd.2D,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlsl_high_laneq_s32(v128 a0, v128 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMUL Dd,Dn,Vm.D[0]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmul_n_f64(v64 a0, Double a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMUL Vd.2D,Vn.2D,Vm.D[0]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmulq_n_f64(v128 a0, Double a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMUL Dd,Dn,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmul_lane_f64(v64 a0, v64 a1, Int32 a2)
            {
                return vmul_f64(a0, a1);
            }

            /// <summary>Floating-point Multiply (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMUL Vd.2D,Vn.2D,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmulq_lane_f64(v128 a0, v64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMUL Sd,Sn,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Single vmuls_lane_f32(Single a0, v64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMUL Dd,Dn,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Double vmuld_lane_f64(Double a0, v64 a1, Int32 a2)
            {
                return a0 * a1.Double0;
            }

            /// <summary>Multiply (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MUL Vd.4H,Vn.4H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmul_laneq_s16(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MUL Vd.8H,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmulq_laneq_s16(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MUL Vd.2S,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmul_laneq_s32(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MUL Vd.4S,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmulq_laneq_s32(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MUL Vd.4H,Vn.4H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmul_laneq_u16(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MUL Vd.8H,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmulq_laneq_u16(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MUL Vd.2S,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmul_laneq_u32(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Multiply (vector, by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>MUL Vd.4S,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmulq_laneq_u32(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMUL Vd.2S,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmul_laneq_f32(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMUL Vd.4S,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmulq_laneq_f32(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMUL Dd,Dn,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vmul_laneq_f64(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMUL Vd.2D,Vn.2D,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmulq_laneq_f64(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMUL Sd,Sn,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Single vmuls_laneq_f32(Single a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Multiply (by element). This instruction multiplies the vector elements in the first source SIMD&amp;FP register by the specified value in the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMUL Dd,Dn,Vm.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static Double vmuld_laneq_f64(Double a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMULL instruction extracts vector elements from the lower half of the first source register, while the SMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMULL2 Vd.4S,Vn.8H,Vm.H[0]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_high_n_s16(v128 a0, Int16 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMULL instruction extracts vector elements from the lower half of the first source register, while the SMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMULL2 Vd.2D,Vn.4S,Vm.S[0]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_high_n_s32(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMULL instruction extracts vector elements from the lower half of the first source register, while the UMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMULL2 Vd.4S,Vn.8H,Vm.H[0]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_high_n_u16(v128 a0, UInt16 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMULL instruction extracts vector elements from the lower half of the first source register, while the UMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMULL2 Vd.2D,Vn.4S,Vm.S[0]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_high_n_u32(v128 a0, UInt32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMULL instruction extracts vector elements from the lower half of the first source register, while the SMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMULL2 Vd.4S,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_high_lane_s16(v128 a0, v64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMULL instruction extracts vector elements from the lower half of the first source register, while the SMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMULL2 Vd.2D,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_high_lane_s32(v128 a0, v64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMULL instruction extracts vector elements from the lower half of the first source register, while the UMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMULL2 Vd.4S,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_high_lane_u16(v128 a0, v64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMULL instruction extracts vector elements from the lower half of the first source register, while the UMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMULL2 Vd.2D,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_high_lane_u32(v128 a0, v64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMULL instruction extracts vector elements from the lower half of the first source register, while the SMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMULL Vd.4S,Vn.4H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_laneq_s16(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMULL instruction extracts vector elements from the lower half of the first source register, while the SMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMULL Vd.2D,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_laneq_s32(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMULL instruction extracts vector elements from the lower half of the first source register, while the UMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMULL Vd.4S,Vn.4H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_laneq_u16(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMULL instruction extracts vector elements from the lower half of the first source register, while the UMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMULL Vd.2D,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_laneq_u32(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMULL instruction extracts vector elements from the lower half of the first source register, while the SMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMULL2 Vd.4S,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_high_laneq_s16(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMULL instruction extracts vector elements from the lower half of the first source register, while the SMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMULL2 Vd.2D,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_high_laneq_s32(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMULL instruction extracts vector elements from the lower half of the first source register, while the UMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMULL2 Vd.4S,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_high_laneq_u16(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, places the results in a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMULL instruction extracts vector elements from the lower half of the first source register, while the UMULL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMULL2 Vd.2D,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmull_high_laneq_u32(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the final results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMULL instruction extracts the first source vector from the lower half of the first source register, while the SQDMULL2 instruction extracts the first source vector from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULL2 Vd.4S,Vn.8H,Vm.H[0]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmull_high_n_s16(v128 a0, Int16 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the final results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMULL instruction extracts the first source vector from the lower half of the first source register, while the SQDMULL2 instruction extracts the first source vector from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULL2 Vd.2D,Vn.4S,Vm.S[0]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmull_high_n_s32(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the final results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMULL instruction extracts the first source vector from the lower half of the first source register, while the SQDMULL2 instruction extracts the first source vector from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULL Sd,Hn,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqdmullh_lane_s16(Int16 a0, v64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the final results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMULL instruction extracts the first source vector from the lower half of the first source register, while the SQDMULL2 instruction extracts the first source vector from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULL Dd,Sn,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int64 vqdmulls_lane_s32(Int32 a0, v64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the final results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMULL instruction extracts the first source vector from the lower half of the first source register, while the SQDMULL2 instruction extracts the first source vector from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULL2 Vd.4S,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmull_high_lane_s16(v128 a0, v64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the final results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMULL instruction extracts the first source vector from the lower half of the first source register, while the SQDMULL2 instruction extracts the first source vector from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULL2 Vd.2D,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmull_high_lane_s32(v128 a0, v64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the final results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMULL instruction extracts the first source vector from the lower half of the first source register, while the SQDMULL2 instruction extracts the first source vector from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULL Vd.4S,Vn.4H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmull_laneq_s16(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the final results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMULL instruction extracts the first source vector from the lower half of the first source register, while the SQDMULL2 instruction extracts the first source vector from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULL Vd.2D,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmull_laneq_s32(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the final results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMULL instruction extracts the first source vector from the lower half of the first source register, while the SQDMULL2 instruction extracts the first source vector from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULL Sd,Hn,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqdmullh_laneq_s16(Int16 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the final results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMULL instruction extracts the first source vector from the lower half of the first source register, while the SQDMULL2 instruction extracts the first source vector from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULL Dd,Sn,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int64 vqdmulls_laneq_s32(Int32 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the final results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMULL instruction extracts the first source vector from the lower half of the first source register, while the SQDMULL2 instruction extracts the first source vector from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULL2 Vd.4S,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmull_high_laneq_s16(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the final results in a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMULL instruction extracts the first source vector from the lower half of the first source register, while the SQDMULL2 instruction extracts the first source vector from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULL2 Vd.2D,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmull_high_laneq_s32(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are truncated. For rounded results, see SQRDMULH.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULH Hd,Hn,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int16 vqdmulhh_lane_s16(Int16 a0, v64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are truncated. For rounded results, see SQRDMULH.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULH Sd,Sn,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqdmulhs_lane_s32(Int32 a0, v64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are truncated. For rounded results, see SQRDMULH.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULH Vd.4H,Vn.4H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vqdmulh_laneq_s16(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are truncated. For rounded results, see SQRDMULH.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULH Vd.8H,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmulhq_laneq_s16(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are truncated. For rounded results, see SQRDMULH.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULH Vd.2S,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vqdmulh_laneq_s32(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are truncated. For rounded results, see SQRDMULH.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULH Vd.4S,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmulhq_laneq_s32(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are truncated. For rounded results, see SQRDMULH.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULH Hd,Hn,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int16 vqdmulhh_laneq_s16(Int16 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are truncated. For rounded results, see SQRDMULH.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMULH Sd,Sn,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqdmulhs_laneq_s32(Int32 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounding Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SQDMULH.If any of the results overflows, they are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRDMULH Hd,Hn,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int16 vqrdmulhh_lane_s16(Int16 a0, v64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounding Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SQDMULH.If any of the results overflows, they are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRDMULH Sd,Sn,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqrdmulhs_lane_s32(Int32 a0, v64 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounding Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SQDMULH.If any of the results overflows, they are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRDMULH Vd.4H,Vn.4H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vqrdmulh_laneq_s16(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounding Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SQDMULH.If any of the results overflows, they are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRDMULH Vd.8H,Vn.8H,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqrdmulhq_laneq_s16(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounding Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SQDMULH.If any of the results overflows, they are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRDMULH Vd.2S,Vn.2S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vqrdmulh_laneq_s32(v64 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounding Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SQDMULH.If any of the results overflows, they are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRDMULH Vd.4S,Vn.4S,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqrdmulhq_laneq_s32(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounding Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SQDMULH.If any of the results overflows, they are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRDMULH Hd,Hn,Vm.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int16 vqrdmulhh_laneq_s16(Int16 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Rounding Doubling Multiply returning High half (by element). This instruction multiplies each vector element in the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, places the most significant half of the final results into a vector, and writes the vector to the destination SIMD&amp;FP register.The results are rounded. For truncated results, see SQDMULH.If any of the results overflows, they are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQRDMULH Sd,Sn,Vm.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqrdmulhs_laneq_s32(Int32 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element in the second source SIMD&amp;FP register, and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.The SMLAL instruction extracts vector elements from the lower half of the first source register, while the SMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLAL2 Vd.4S,Vn.8H,Vm.H[0]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_high_n_s16(v128 a0, v128 a1, Int16 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element in the second source SIMD&amp;FP register, and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.The SMLAL instruction extracts vector elements from the lower half of the first source register, while the SMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLAL2 Vd.2D,Vn.4S,Vm.S[0]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_high_n_s32(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLAL instruction extracts vector elements from the lower half of the first source register, while the UMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLAL2 Vd.4S,Vn.8H,Vm.H[0]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_high_n_u16(v128 a0, v128 a1, UInt16 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Add Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and accumulates the results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLAL instruction extracts vector elements from the lower half of the first source register, while the UMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLAL2 Vd.2D,Vn.4S,Vm.S[0]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlal_high_n_u32(v128 a0, v128 a1, UInt32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Add Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLAL instruction extracts vector elements from the lower half of the first source register, while the SQDMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLAL2 Vd.4S,Vn.8H,Vm.H[0]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlal_high_n_s16(v128 a0, v128 a1, Int16 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Add Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and accumulates the final results with the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLAL instruction extracts vector elements from the lower half of the first source register, while the SQDMLAL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLAL2 Vd.2D,Vn.4S,Vm.S[0]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlal_high_n_s32(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMLSL instruction extracts vector elements from the lower half of the first source register, while the SMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLSL2 Vd.4S,Vn.8H,Vm.H[0]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_high_n_s16(v128 a0, v128 a1, Int16 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The SMLSL instruction extracts vector elements from the lower half of the first source register, while the SMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMLSL2 Vd.2D,Vn.4S,Vm.S[0]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_high_n_s32(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLSL instruction extracts vector elements from the lower half of the first source register, while the UMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLSL2 Vd.4S,Vn.8H,Vm.H[0]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_high_n_u16(v128 a0, v128 a1, UInt16 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Multiply-Subtract Long (vector, by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register and subtracts the results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied.The UMLSL instruction extracts vector elements from the lower half of the first source register, while the UMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMLSL2 Vd.2D,Vn.4S,Vm.S[0]</c></summary>
            [DebuggerStepThrough]
            public static v128 vmlsl_high_n_u32(v128 a0, v128 a1, UInt32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Subtract Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and subtracts the final results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLSL instruction extracts vector elements from the lower half of the first source register, while the SQDMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLSL2 Vd.4S,Vn.8H,Vm.H[0]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlsl_high_n_s16(v128 a0, v128 a1, Int16 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Doubling Multiply-Subtract Long (by element). This instruction multiplies each vector element in the lower or upper half of the first source SIMD&amp;FP register by the specified vector element of the second source SIMD&amp;FP register, doubles the results, and subtracts the final results from the vector elements of the destination SIMD&amp;FP register. The destination vector elements are twice as long as the elements that are multiplied. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.The SQDMLSL instruction extracts vector elements from the lower half of the first source register, while the SQDMLSL2 instruction extracts vector elements from the upper half of the first source register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQDMLSL2 Vd.2D,Vn.4S,Vm.S[0]</c></summary>
            [DebuggerStepThrough]
            public static v128 vqdmlsl_high_n_s32(v128 a0, v128 a1, Int32 a2)
            {
                throw new NotImplementedException();
            }

            /// <summary>Absolute value (vector). This instruction calculates the absolute value of each vector element in the source SIMD&amp;FP register, puts the result into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ABS Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vabs_s64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Absolute value (vector). This instruction calculates the absolute value of each vector element in the source SIMD&amp;FP register, puts the result into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ABS Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static Int64 vabsd_s64(Int64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Absolute value (vector). This instruction calculates the absolute value of each vector element in the source SIMD&amp;FP register, puts the result into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ABS Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vabsq_s64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute value (vector). This instruction calculates the absolute value of each vector element in the source SIMD&amp;FP register, writes the result to a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FABS Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vabs_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Absolute value (vector). This instruction calculates the absolute value of each vector element in the source SIMD&amp;FP register, writes the result to a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FABS Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vabsq_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Absolute value. This instruction reads each vector element from the source SIMD&amp;FP register, puts the absolute value of the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQABS Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vqabs_s64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Absolute value. This instruction reads each vector element from the source SIMD&amp;FP register, puts the absolute value of the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQABS Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vqabsq_s64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Absolute value. This instruction reads each vector element from the source SIMD&amp;FP register, puts the absolute value of the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQABS Bd,Bn</c></summary>
            [DebuggerStepThrough]
            public static SByte vqabsb_s8(SByte a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Absolute value. This instruction reads each vector element from the source SIMD&amp;FP register, puts the absolute value of the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQABS Hd,Hn</c></summary>
            [DebuggerStepThrough]
            public static Int16 vqabsh_s16(Int16 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Absolute value. This instruction reads each vector element from the source SIMD&amp;FP register, puts the absolute value of the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQABS Sd,Sn</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqabss_s32(Int32 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Absolute value. This instruction reads each vector element from the source SIMD&amp;FP register, puts the absolute value of the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQABS Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static Int64 vqabsd_s64(Int64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Negate (vector). This instruction reads each vector element from the source SIMD&amp;FP register, negates each value, puts the result into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>NEG Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vneg_s64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Negate (vector). This instruction reads each vector element from the source SIMD&amp;FP register, negates each value, puts the result into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>NEG Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static Int64 vnegd_s64(Int64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Negate (vector). This instruction reads each vector element from the source SIMD&amp;FP register, negates each value, puts the result into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>NEG Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vnegq_s64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Negate (vector). This instruction negates the value of each vector element in the source SIMD&amp;FP register, writes the result to a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FNEG Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vneg_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Negate (vector). This instruction negates the value of each vector element in the source SIMD&amp;FP register, writes the result to a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FNEG Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vnegq_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Negate. This instruction reads each vector element from the source SIMD&amp;FP register, negates each value, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQNEG Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vqneg_s64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Negate. This instruction reads each vector element from the source SIMD&amp;FP register, negates each value, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQNEG Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vqnegq_s64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Negate. This instruction reads each vector element from the source SIMD&amp;FP register, negates each value, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQNEG Bd,Bn</c></summary>
            [DebuggerStepThrough]
            public static SByte vqnegb_s8(SByte a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Negate. This instruction reads each vector element from the source SIMD&amp;FP register, negates each value, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQNEG Hd,Hn</c></summary>
            [DebuggerStepThrough]
            public static Int16 vqnegh_s16(Int16 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Negate. This instruction reads each vector element from the source SIMD&amp;FP register, negates each value, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQNEG Sd,Sn</c></summary>
            [DebuggerStepThrough]
            public static Int32 vqnegs_s32(Int32 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed saturating Negate. This instruction reads each vector element from the source SIMD&amp;FP register, negates each value, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.If overflow occurs with any of the results, those results are saturated. If saturation occurs, the cumulative saturation bit FPSR.QC is set.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SQNEG Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static Int64 vqnegd_s64(Int64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Reciprocal Estimate. This instruction finds an approximate reciprocal estimate for each vector element in the source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRECPE Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vrecpe_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Reciprocal Estimate. This instruction finds an approximate reciprocal estimate for each vector element in the source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRECPE Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vrecpeq_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Reciprocal Estimate. This instruction finds an approximate reciprocal estimate for each vector element in the source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRECPE Sd,Sn</c></summary>
            [DebuggerStepThrough]
            public static Single vrecpes_f32(Single a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Reciprocal Estimate. This instruction finds an approximate reciprocal estimate for each vector element in the source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRECPE Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static Double vrecped_f64(Double a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Reciprocal Step. This instruction multiplies the corresponding floating-point values in the vectors of the two source SIMD&amp;FP registers, subtracts each of the products from 2.0, places the resulting floating-point values in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRECPS Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vrecps_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Reciprocal Step. This instruction multiplies the corresponding floating-point values in the vectors of the two source SIMD&amp;FP registers, subtracts each of the products from 2.0, places the resulting floating-point values in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRECPS Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vrecpsq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Reciprocal Step. This instruction multiplies the corresponding floating-point values in the vectors of the two source SIMD&amp;FP registers, subtracts each of the products from 2.0, places the resulting floating-point values in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRECPS Sd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static Single vrecpss_f32(Single a0, Single a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Reciprocal Step. This instruction multiplies the corresponding floating-point values in the vectors of the two source SIMD&amp;FP registers, subtracts each of the products from 2.0, places the resulting floating-point values in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRECPS Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static Double vrecpsd_f64(Double a0, Double a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Square Root (vector). This instruction calculates the square root for each vector element in the source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FSQRT Vd.2S,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vsqrt_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Square Root (vector). This instruction calculates the square root for each vector element in the source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FSQRT Vd.4S,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vsqrtq_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Square Root (vector). This instruction calculates the square root for each vector element in the source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FSQRT Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vsqrt_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Square Root (vector). This instruction calculates the square root for each vector element in the source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FSQRT Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vsqrtq_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Reciprocal Square Root Estimate. This instruction calculates an approximate square root for each vector element in the source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRSQRTE Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static v64 vrsqrte_f64(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Reciprocal Square Root Estimate. This instruction calculates an approximate square root for each vector element in the source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRSQRTE Vd.2D,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vrsqrteq_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Reciprocal Square Root Estimate. This instruction calculates an approximate square root for each vector element in the source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRSQRTE Sd,Sn</c></summary>
            [DebuggerStepThrough]
            public static Single vrsqrtes_f32(Single a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Reciprocal Square Root Estimate. This instruction calculates an approximate square root for each vector element in the source SIMD&amp;FP register, places the result in a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRSQRTE Dd,Dn</c></summary>
            [DebuggerStepThrough]
            public static Double vrsqrted_f64(Double a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Reciprocal Square Root Step. This instruction multiplies corresponding floating-point values in the vectors of the two source SIMD&amp;FP registers, subtracts each of the products from 3.0, divides these results by 2.0, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRSQRTS Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static v64 vrsqrts_f64(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Reciprocal Square Root Step. This instruction multiplies corresponding floating-point values in the vectors of the two source SIMD&amp;FP registers, subtracts each of the products from 3.0, divides these results by 2.0, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRSQRTS Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vrsqrtsq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Reciprocal Square Root Step. This instruction multiplies corresponding floating-point values in the vectors of the two source SIMD&amp;FP registers, subtracts each of the products from 3.0, divides these results by 2.0, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRSQRTS Sd,Sn,Sm</c></summary>
            [DebuggerStepThrough]
            public static Single vrsqrtss_f32(Single a0, Single a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Reciprocal Square Root Step. This instruction multiplies corresponding floating-point values in the vectors of the two source SIMD&amp;FP registers, subtracts each of the products from 3.0, divides these results by 2.0, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR, or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FRSQRTS Dd,Dn,Dm</c></summary>
            [DebuggerStepThrough]
            public static Double vrsqrtsd_f64(Double a0, Double a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Bitwise Select. This instruction sets each bit in the destination SIMD&amp;FP register to the corresponding bit from the first source SIMD&amp;FP register when the original destination bit was 1, otherwise from the second source SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>BSL Vd.8B,Vn.8B,Vm.8B</c></summary>
            [DebuggerStepThrough]
            public static v64 vbsl_f64(v64 a0, v64 a1, v64 a2)
            {
                return vbsl_s8(a0, a1, a2);
            }

            /// <summary>Bitwise Select. This instruction sets each bit in the destination SIMD&amp;FP register to the corresponding bit from the first source SIMD&amp;FP register when the original destination bit was 1, otherwise from the second source SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>BSL Vd.16B,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vbslq_f64(v128 a0, v128 a1, v128 a2)
            {
                return vbslq_s8(a0, a1, a2);
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.B[lane1],Vn.B[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_lane_s8(v64 a0, Int32 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.B[lane1],Vn.B[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_lane_s8(v128 a0, Int32 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.H[lane1],Vn.H[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_lane_s16(v64 a0, Int32 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.H[lane1],Vn.H[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_lane_s16(v128 a0, Int32 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.S[lane1],Vn.S[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_lane_s32(v64 a0, Int32 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.S[lane1],Vn.S[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_lane_s32(v128 a0, Int32 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Dd,Vn.D[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_lane_s64(v64 a0, Int32 a1, v64 a2, Int32 a3)
            {
                return a2;
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.D[lane1],Vn.D[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_lane_s64(v128 a0, Int32 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.B[lane1],Vn.B[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_lane_u8(v64 a0, Int32 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.B[lane1],Vn.B[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_lane_u8(v128 a0, Int32 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.H[lane1],Vn.H[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_lane_u16(v64 a0, Int32 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.H[lane1],Vn.H[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_lane_u16(v128 a0, Int32 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.S[lane1],Vn.S[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_lane_u32(v64 a0, Int32 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.S[lane1],Vn.S[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_lane_u32(v128 a0, Int32 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Dd,Vn.D[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_lane_u64(v64 a0, Int32 a1, v64 a2, Int32 a3)
            {
                return a2;
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.D[lane1],Vn.D[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_lane_u64(v128 a0, Int32 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.S[lane1],Vn.S[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_lane_f32(v64 a0, Int32 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.S[lane1],Vn.S[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_lane_f32(v128 a0, Int32 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Dd,Vn.D[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_lane_f64(v64 a0, Int32 a1, v64 a2, Int32 a3)
            {
                return a2;
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.D[lane1],Vn.D[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_lane_f64(v128 a0, Int32 a1, v64 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.B[lane1],Vn.B[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_laneq_s8(v64 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.B[lane1],Vn.B[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_laneq_s8(v128 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.H[lane1],Vn.H[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_laneq_s16(v64 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.H[lane1],Vn.H[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_laneq_s16(v128 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.S[lane1],Vn.S[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_laneq_s32(v64 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.S[lane1],Vn.S[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_laneq_s32(v128 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Dd,Vn.D[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_laneq_s64(v64 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.D[lane1],Vn.D[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_laneq_s64(v128 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.B[lane1],Vn.B[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_laneq_u8(v64 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.B[lane1],Vn.B[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_laneq_u8(v128 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.H[lane1],Vn.H[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_laneq_u16(v64 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.H[lane1],Vn.H[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_laneq_u16(v128 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.S[lane1],Vn.S[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_laneq_u32(v64 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.S[lane1],Vn.S[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_laneq_u32(v128 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Dd,Vn.D[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_laneq_u64(v64 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.D[lane1],Vn.D[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_laneq_u64(v128 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.S[lane1],Vn.S[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_laneq_f32(v64 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.S[lane1],Vn.S[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_laneq_f32(v128 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Dd,Vn.D[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v64 vcopy_laneq_f64(v64 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Insert vector element from another vector element. This instruction copies the vector element of the source SIMD&amp;FP register to the specified vector element of the destination SIMD&amp;FP register.This instruction can insert data into individual elements within a SIMD&amp;FP register without clearing the remaining bits to zero.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>INS Vd.D[lane1],Vn.D[lane2]</c></summary>
            [DebuggerStepThrough]
            public static v128 vcopyq_laneq_f64(v128 a0, Int32 a1, v128 a2, Int32 a3)
            {
                throw new NotImplementedException();
            }

            /// <summary>Reverse Bit order (vector). This instruction reads each vector element from the source SIMD&amp;FP register, reverses the bits of the element, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RBIT Vd.8B,Vn.8B</c></summary>
            [DebuggerStepThrough]
            public static v64 vrbit_s8(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Reverse Bit order (vector). This instruction reads each vector element from the source SIMD&amp;FP register, reverses the bits of the element, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RBIT Vd.16B,Vn.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vrbitq_s8(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Reverse Bit order (vector). This instruction reads each vector element from the source SIMD&amp;FP register, reverses the bits of the element, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RBIT Vd.8B,Vn.8B</c></summary>
            [DebuggerStepThrough]
            public static v64 vrbit_u8(v64 a0)
            {
                return vrbit_s8(a0);
            }

            /// <summary>Reverse Bit order (vector). This instruction reads each vector element from the source SIMD&amp;FP register, reverses the bits of the element, places the results into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>RBIT Vd.16B,Vn.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vrbitq_u8(v128 a0)
            {
                return vrbitq_s8(a0);
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Dd,Vn.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vdup_lane_f64(v64 a0, Int32 a1)
            {
                return a0;
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Vd.2D,Vn.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vdupq_lane_f64(v64 a0, Int32 a1)
            {
                return new v128(a0, a0);
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Vd.8B,Vn.B[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vdup_laneq_s8(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Vd.16B,Vn.B[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vdupq_laneq_s8(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Vd.4H,Vn.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vdup_laneq_s16(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Vd.8H,Vn.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vdupq_laneq_s16(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Vd.2S,Vn.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vdup_laneq_s32(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Vd.4S,Vn.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vdupq_laneq_s32(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Dd,Vn.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vdup_laneq_s64(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Vd.2D,Vn.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vdupq_laneq_s64(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Vd.8B,Vn.B[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vdup_laneq_u8(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Vd.16B,Vn.B[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vdupq_laneq_u8(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Vd.4H,Vn.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vdup_laneq_u16(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Vd.8H,Vn.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vdupq_laneq_u16(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Vd.2S,Vn.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vdup_laneq_u32(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Vd.4S,Vn.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vdupq_laneq_u32(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Dd,Vn.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vdup_laneq_u64(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Vd.2D,Vn.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vdupq_laneq_u64(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Vd.2S,Vn.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vdup_laneq_f32(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Vd.4S,Vn.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vdupq_laneq_f32(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Dd,Vn.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v64 vdup_laneq_f64(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Vd.2D,Vn.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static v128 vdupq_laneq_f64(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Bd,Vn.B[lane]</c></summary>
            [DebuggerStepThrough]
            public static SByte vdupb_lane_s8(v64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Hd,Vn.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int16 vduph_lane_s16(v64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Sd,Vn.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int32 vdups_lane_s32(v64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Dd,Vn.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int64 vdupd_lane_s64(v64 a0, Int32 a1)
            {
                return a0.SLong0;
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Bd,Vn.B[lane]</c></summary>
            [DebuggerStepThrough]
            public static Byte vdupb_lane_u8(v64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Hd,Vn.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vduph_lane_u16(v64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Sd,Vn.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vdups_lane_u32(v64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Dd,Vn.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vdupd_lane_u64(v64 a0, Int32 a1)
            {
                return a0.ULong0;
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Sd,Vn.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Single vdups_lane_f32(v64 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Dd,Vn.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static Double vdupd_lane_f64(v64 a0, Int32 a1)
            {
                return a0.Double0;
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Bd,Vn.B[lane]</c></summary>
            [DebuggerStepThrough]
            public static SByte vdupb_laneq_s8(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Hd,Vn.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int16 vduph_laneq_s16(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Sd,Vn.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int32 vdups_laneq_s32(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Dd,Vn.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static Int64 vdupd_laneq_s64(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Bd,Vn.B[lane]</c></summary>
            [DebuggerStepThrough]
            public static Byte vdupb_laneq_u8(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Hd,Vn.H[lane]</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vduph_laneq_u16(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Sd,Vn.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vdups_laneq_u32(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Dd,Vn.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vdupd_laneq_u64(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Sd,Vn.S[lane]</c></summary>
            [DebuggerStepThrough]
            public static Single vdups_laneq_f32(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Duplicate vector element to vector or scalar. This instruction duplicates the vector element at the specified element index in the source SIMD&amp;FP register into a scalar or each element in a vector, and writes the result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>DUP Dd,Vn.D[lane]</c></summary>
            [DebuggerStepThrough]
            public static Double vdupd_laneq_f64(v128 a0, Int32 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add Pair of elements (scalar). This instruction adds two vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDP Vd.16B,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vpaddq_s8(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add Pair of elements (scalar). This instruction adds two vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDP Vd.8H,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vpaddq_s16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add Pair of elements (scalar). This instruction adds two vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDP Vd.4S,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vpaddq_s32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add Pair of elements (scalar). This instruction adds two vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDP Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vpaddq_s64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add Pair of elements (scalar). This instruction adds two vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDP Vd.16B,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vpaddq_u8(v128 a0, v128 a1)
            {
                return vpaddq_s8(a0, a1);
            }

            /// <summary>Add Pair of elements (scalar). This instruction adds two vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDP Vd.8H,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vpaddq_u16(v128 a0, v128 a1)
            {
                return vpaddq_s16(a0, a1);
            }

            /// <summary>Add Pair of elements (scalar). This instruction adds two vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDP Vd.4S,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vpaddq_u32(v128 a0, v128 a1)
            {
                return vpaddq_s32(a0, a1);
            }

            /// <summary>Add Pair of elements (scalar). This instruction adds two vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDP Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vpaddq_u64(v128 a0, v128 a1)
            {
                return vpaddq_s64(a0, a1);
            }

            /// <summary>Floating-point Add Pair of elements (scalar). This instruction adds two floating-point vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FADDP Vd.4S,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vpaddq_f32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Add Pair of elements (scalar). This instruction adds two floating-point vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FADDP Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vpaddq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Maximum Pairwise. This instruction creates a vector by concatenating the vector elements of the first source SIMD&amp;FP register after the vector elements of the second source SIMD&amp;FP register, reads each pair of adjacent vector elements in the two source SIMD&amp;FP registers, writes the largest of each pair of signed integer values into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMAXP Vd.16B,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vpmaxq_s8(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Maximum Pairwise. This instruction creates a vector by concatenating the vector elements of the first source SIMD&amp;FP register after the vector elements of the second source SIMD&amp;FP register, reads each pair of adjacent vector elements in the two source SIMD&amp;FP registers, writes the largest of each pair of signed integer values into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMAXP Vd.8H,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vpmaxq_s16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Maximum Pairwise. This instruction creates a vector by concatenating the vector elements of the first source SIMD&amp;FP register after the vector elements of the second source SIMD&amp;FP register, reads each pair of adjacent vector elements in the two source SIMD&amp;FP registers, writes the largest of each pair of signed integer values into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMAXP Vd.4S,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vpmaxq_s32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Maximum Pairwise. This instruction creates a vector by concatenating the vector elements of the first source SIMD&amp;FP register after the vector elements of the second source SIMD&amp;FP register, reads each pair of adjacent vector elements in the two source SIMD&amp;FP registers, writes the largest of each pair of unsigned integer values into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMAXP Vd.16B,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vpmaxq_u8(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Maximum Pairwise. This instruction creates a vector by concatenating the vector elements of the first source SIMD&amp;FP register after the vector elements of the second source SIMD&amp;FP register, reads each pair of adjacent vector elements in the two source SIMD&amp;FP registers, writes the largest of each pair of unsigned integer values into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMAXP Vd.8H,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vpmaxq_u16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Maximum Pairwise. This instruction creates a vector by concatenating the vector elements of the first source SIMD&amp;FP register after the vector elements of the second source SIMD&amp;FP register, reads each pair of adjacent vector elements in the two source SIMD&amp;FP registers, writes the largest of each pair of unsigned integer values into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMAXP Vd.4S,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vpmaxq_u32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Maximum of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the largest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMAXP Vd.4S,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vpmaxq_f32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Maximum of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the largest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMAXP Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vpmaxq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Minimum Pairwise. This instruction creates a vector by concatenating the vector elements of the first source SIMD&amp;FP register after the vector elements of the second source SIMD&amp;FP register, reads each pair of adjacent vector elements in the two source SIMD&amp;FP registers, writes the smallest of each pair of signed integer values into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMINP Vd.16B,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vpminq_s8(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Minimum Pairwise. This instruction creates a vector by concatenating the vector elements of the first source SIMD&amp;FP register after the vector elements of the second source SIMD&amp;FP register, reads each pair of adjacent vector elements in the two source SIMD&amp;FP registers, writes the smallest of each pair of signed integer values into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMINP Vd.8H,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vpminq_s16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Minimum Pairwise. This instruction creates a vector by concatenating the vector elements of the first source SIMD&amp;FP register after the vector elements of the second source SIMD&amp;FP register, reads each pair of adjacent vector elements in the two source SIMD&amp;FP registers, writes the smallest of each pair of signed integer values into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMINP Vd.4S,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vpminq_s32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Minimum Pairwise. This instruction creates a vector by concatenating the vector elements of the first source SIMD&amp;FP register after the vector elements of the second source SIMD&amp;FP register, reads each pair of adjacent vector elements in the two source SIMD&amp;FP registers, writes the smallest of each pair of unsigned integer values into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMINP Vd.16B,Vn.16B,Vm.16B</c></summary>
            [DebuggerStepThrough]
            public static v128 vpminq_u8(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Minimum Pairwise. This instruction creates a vector by concatenating the vector elements of the first source SIMD&amp;FP register after the vector elements of the second source SIMD&amp;FP register, reads each pair of adjacent vector elements in the two source SIMD&amp;FP registers, writes the smallest of each pair of unsigned integer values into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMINP Vd.8H,Vn.8H,Vm.8H</c></summary>
            [DebuggerStepThrough]
            public static v128 vpminq_u16(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Minimum Pairwise. This instruction creates a vector by concatenating the vector elements of the first source SIMD&amp;FP register after the vector elements of the second source SIMD&amp;FP register, reads each pair of adjacent vector elements in the two source SIMD&amp;FP registers, writes the smallest of each pair of unsigned integer values into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMINP Vd.4S,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vpminq_u32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Minimum of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the smallest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMINP Vd.4S,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vpminq_f32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Minimum of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the smallest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMINP Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vpminq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Maximum Number of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the largest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMAXNMP Vd.2S,Vn.2S,Vm.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vpmaxnm_f32(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Maximum Number of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the largest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMAXNMP Vd.4S,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vpmaxnmq_f32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Maximum Number of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the largest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMAXNMP Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vpmaxnmq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Minimum Number of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the smallest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMINNMP Vd.2S,Vn.2S,Vm.2S</c></summary>
            [DebuggerStepThrough]
            public static v64 vpminnm_f32(v64 a0, v64 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Minimum Number of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the smallest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMINNMP Vd.4S,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static v128 vpminnmq_f32(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Minimum Number of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the smallest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMINNMP Vd.2D,Vn.2D,Vm.2D</c></summary>
            [DebuggerStepThrough]
            public static v128 vpminnmq_f64(v128 a0, v128 a1)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add Pair of elements (scalar). This instruction adds two vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDP Dd,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static Int64 vpaddd_s64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add Pair of elements (scalar). This instruction adds two vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDP Dd,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vpaddd_u64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Add Pair of elements (scalar). This instruction adds two floating-point vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FADDP Sd,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static Single vpadds_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Add Pair of elements (scalar). This instruction adds two floating-point vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FADDP Dd,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static Double vpaddd_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Maximum of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the largest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMAXP Sd,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static Single vpmaxs_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Maximum of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the largest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMAXP Dd,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static Double vpmaxqd_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Minimum of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the smallest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMINP Sd,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static Single vpmins_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Minimum of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the smallest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMINP Dd,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static Double vpminqd_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Maximum Number of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the largest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMAXNMP Sd,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static Single vpmaxnms_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Maximum Number of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the largest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMAXNMP Dd,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static Double vpmaxnmqd_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Minimum Number of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the smallest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMINNMP Sd,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static Single vpminnms_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Minimum Number of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the smallest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMINNMP Dd,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static Double vpminnmqd_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDV Bd,Vn.8B</c></summary>
            [DebuggerStepThrough]
            public static SByte vaddv_s8(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDV Bd,Vn.16B</c></summary>
            [DebuggerStepThrough]
            public static SByte vaddvq_s8(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDV Hd,Vn.4H</c></summary>
            [DebuggerStepThrough]
            public static Int16 vaddv_s16(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDV Hd,Vn.8H</c></summary>
            [DebuggerStepThrough]
            public static Int16 vaddvq_s16(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add Pair of elements (scalar). This instruction adds two vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDP  Vd.2S,Vn.2S,Vm.2S</c></summary>
            [DebuggerStepThrough]
            public static Int32 vaddv_s32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDV Sd,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static Int32 vaddvq_s32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add Pair of elements (scalar). This instruction adds two vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDP Dd,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static Int64 vaddvq_s64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDV Bd,Vn.8B</c></summary>
            [DebuggerStepThrough]
            public static Byte vaddv_u8(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDV Bd,Vn.16B</c></summary>
            [DebuggerStepThrough]
            public static Byte vaddvq_u8(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDV Hd,Vn.4H</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vaddv_u16(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDV Hd,Vn.8H</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vaddvq_u16(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add Pair of elements (scalar). This instruction adds two vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDP  Vd.2S,Vn.2S,Vm.2S</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vaddv_u32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDV Sd,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vaddvq_u32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Add Pair of elements (scalar). This instruction adds two vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>ADDP Dd,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vaddvq_u64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Add Pair of elements (scalar). This instruction adds two floating-point vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FADDP Sd,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static Single vaddv_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Add Pair of elements (scalar). This instruction adds two floating-point vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FADDP Vt.4S,Vn.4S,Vm.4S</c></summary>
            [DebuggerStepThrough]
            public static Single vaddvq_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Add Pair of elements (scalar). This instruction adds two floating-point vector elements in the source SIMD&amp;FP register and writes the scalar result into the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FADDP Dd,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static Double vaddvq_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Add Long across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register. The destination scalar is twice as long as the source vector elements. All the values in this instruction are signed integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SADDLV Hd,Vn.8B</c></summary>
            [DebuggerStepThrough]
            public static Int16 vaddlv_s8(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Add Long across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register. The destination scalar is twice as long as the source vector elements. All the values in this instruction are signed integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SADDLV Hd,Vn.16B</c></summary>
            [DebuggerStepThrough]
            public static Int16 vaddlvq_s8(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Add Long across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register. The destination scalar is twice as long as the source vector elements. All the values in this instruction are signed integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SADDLV Sd,Vn.4H</c></summary>
            [DebuggerStepThrough]
            public static Int32 vaddlv_s16(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Add Long across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register. The destination scalar is twice as long as the source vector elements. All the values in this instruction are signed integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SADDLV Sd,Vn.8H</c></summary>
            [DebuggerStepThrough]
            public static Int32 vaddlvq_s16(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Add Long Pairwise. This instruction adds pairs of adjacent signed integer values from the vector in the source SIMD&amp;FP register, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SADDLP Vd.1D,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static Int64 vaddlv_s32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Add Long across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register. The destination scalar is twice as long as the source vector elements. All the values in this instruction are signed integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SADDLV Dd,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static Int64 vaddlvq_s32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned sum Long across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register. The destination scalar is twice as long as the source vector elements. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UADDLV Hd,Vn.8B</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vaddlv_u8(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned sum Long across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register. The destination scalar is twice as long as the source vector elements. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UADDLV Hd,Vn.16B</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vaddlvq_u8(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned sum Long across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register. The destination scalar is twice as long as the source vector elements. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UADDLV Sd,Vn.4H</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vaddlv_u16(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned sum Long across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register. The destination scalar is twice as long as the source vector elements. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UADDLV Sd,Vn.8H</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vaddlvq_u16(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Add Long Pairwise. This instruction adds pairs of adjacent unsigned integer values from the vector in the source SIMD&amp;FP register, places the result into a vector, and writes the vector to the destination SIMD&amp;FP register. The destination vector elements are twice as long as the source vector elements.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UADDLP Vd.1D,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vaddlv_u32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned sum Long across Vector. This instruction adds every vector element in the source SIMD&amp;FP register together, and writes the scalar result to the destination SIMD&amp;FP register. The destination scalar is twice as long as the source vector elements. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UADDLV Dd,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static UInt64 vaddlvq_u32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Maximum across Vector. This instruction compares all the vector elements in the source SIMD&amp;FP register, and writes the largest of the values as a scalar to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMAXV Bd,Vn.8B</c></summary>
            [DebuggerStepThrough]
            public static SByte vmaxv_s8(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Maximum across Vector. This instruction compares all the vector elements in the source SIMD&amp;FP register, and writes the largest of the values as a scalar to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMAXV Bd,Vn.16B</c></summary>
            [DebuggerStepThrough]
            public static SByte vmaxvq_s8(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Maximum across Vector. This instruction compares all the vector elements in the source SIMD&amp;FP register, and writes the largest of the values as a scalar to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMAXV Hd,Vn.4H</c></summary>
            [DebuggerStepThrough]
            public static Int16 vmaxv_s16(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Maximum across Vector. This instruction compares all the vector elements in the source SIMD&amp;FP register, and writes the largest of the values as a scalar to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMAXV Hd,Vn.8H</c></summary>
            [DebuggerStepThrough]
            public static Int16 vmaxvq_s16(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Maximum Pairwise. This instruction creates a vector by concatenating the vector elements of the first source SIMD&amp;FP register after the vector elements of the second source SIMD&amp;FP register, reads each pair of adjacent vector elements in the two source SIMD&amp;FP registers, writes the largest of each pair of signed integer values into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMAXP  Vd.2S,Vn.2S,Vm.2S</c></summary>
            [DebuggerStepThrough]
            public static Int32 vmaxv_s32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Maximum across Vector. This instruction compares all the vector elements in the source SIMD&amp;FP register, and writes the largest of the values as a scalar to the destination SIMD&amp;FP register. All the values in this instruction are signed integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>SMAXV Sd,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static Int32 vmaxvq_s32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Maximum across Vector. This instruction compares all the vector elements in the source SIMD&amp;FP register, and writes the largest of the values as a scalar to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMAXV Bd,Vn.8B</c></summary>
            [DebuggerStepThrough]
            public static Byte vmaxv_u8(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Maximum across Vector. This instruction compares all the vector elements in the source SIMD&amp;FP register, and writes the largest of the values as a scalar to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMAXV Bd,Vn.16B</c></summary>
            [DebuggerStepThrough]
            public static Byte vmaxvq_u8(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Maximum across Vector. This instruction compares all the vector elements in the source SIMD&amp;FP register, and writes the largest of the values as a scalar to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMAXV Hd,Vn.4H</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vmaxv_u16(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Maximum across Vector. This instruction compares all the vector elements in the source SIMD&amp;FP register, and writes the largest of the values as a scalar to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMAXV Hd,Vn.8H</c></summary>
            [DebuggerStepThrough]
            public static UInt16 vmaxvq_u16(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Maximum Pairwise. This instruction creates a vector by concatenating the vector elements of the first source SIMD&amp;FP register after the vector elements of the second source SIMD&amp;FP register, reads each pair of adjacent vector elements in the two source SIMD&amp;FP registers, writes the largest of each pair of unsigned integer values into a vector, and writes the vector to the destination SIMD&amp;FP register.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMAXP  Vd.2S,Vn.2S,Vm.2S</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vmaxv_u32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Unsigned Maximum across Vector. This instruction compares all the vector elements in the source SIMD&amp;FP register, and writes the largest of the values as a scalar to the destination SIMD&amp;FP register. All the values in this instruction are unsigned integer values.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>UMAXV Sd,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static UInt32 vmaxvq_u32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Maximum of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the largest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMAXP Sd,Vn.2S</c></summary>
            [DebuggerStepThrough]
            public static Single vmaxv_f32(v64 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Maximum across Vector. This instruction compares all the vector elements in the source SIMD&amp;FP register, and writes the largest of the values as a scalar to the destination SIMD&amp;FP register. All the values in this instruction are floating-point values.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMAXV Sd,Vn.4S</c></summary>
            [DebuggerStepThrough]
            public static Single vmaxvq_f32(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Floating-point Maximum of Pair of elements (scalar). This instruction compares two vector elements in the source SIMD&amp;FP register and writes the largest of the floating-point values as a scalar to the destination SIMD&amp;FP register.This instruction can generate a floating-point exception. Depending on the settings in FPCR, the exception results in either a flag being set in FPSR or a synchronous exception being generated. For more information, see Floating-point exception traps.Depending on the settings in the CPACR_EL1, CPTR_EL2, and CPTR_EL3 registers, and the current Security state and Exception level, an attempt to execute the instruction might be trapped.
            /// <br/>Equivalent instruction: <c>FMAXP Dd,Vn.2D</c></summary>
            [DebuggerStepThrough]
            public static Double vmaxvq_f64(v128 a0)
            {
                throw new NotImplementedException();
            }

            /// <summary>Signed Minimum across Vector. This instruction compares all the vector elements in 